/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.filewatcher;

import java.io.File;
import java.util.UUID;
import org.eclipse.codewind.filewatchers.JavaNioWatchService;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.IAuthTokenProvider;
import org.eclipse.codewind.filewatchers.core.IPlatformWatchService;

public class CodewindIntelliJFilewatcherdConnection {
    private final String baseHttpUrl;
    private final Filewatcher fileWatcher;
    private final String clientUuid;

    public CodewindIntelliJFilewatcherdConnection(String baseHttpUrl, File pathToCwctl, IAuthTokenProvider authTokenProvider) {
        if (pathToCwctl == null) {
            throw new RuntimeException("A valid path to the Codewind CLI is required: " + pathToCwctl);
        }
        if (!pathToCwctl.exists() || !pathToCwctl.canExecute()) {
            throw new RuntimeException(this.getClass().getSimpleName() + " was passed an invalid installer path: " + pathToCwctl.getPath());
        }
        this.clientUuid = UUID.randomUUID().toString();
        String url = baseHttpUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("Argument should begin with http:// or https://.");
        }
        this.fileWatcher = new Filewatcher(url, this.clientUuid, (IPlatformWatchService)new JavaNioWatchService(), null, pathToCwctl.getPath(), authTokenProvider);
        this.baseHttpUrl = url;
    }

    public String getClientUuid() {
        return this.clientUuid;
    }

    public void dispose() {
        try {
            this.fileWatcher.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

