/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;

public class RestartDebugModeTask
extends Task.Backgroundable {
    private final CodewindApplication application;

    public RestartDebugModeTask(CodewindApplication application, Project project) {
        super(project, CodewindUIBundle.message("RestartInDebugMode", new Object[0]));
        this.application = application;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RestartDebugModeTask.$$$reportNull$$$0(0);
        }
        if (this.application.projectLanguage.isJava()) {
            try {
                this.application.clearDebugger();
                if (this.application.getProjectCapabilities().supportsDebugMode()) {
                    this.application.connection.requestProjectRestart(this.application, StartMode.DEBUG.startMode);
                } else if (this.application.getProjectCapabilities().supportsDebugNoInitMode()) {
                    this.application.connection.requestProjectRestart(this.application, StartMode.DEBUG_NO_INIT.startMode);
                } else {
                    Logger.log("Project restart in debug mode requested but project does not support any debug modes: " + this.application.name);
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/tasks/RestartDebugModeTask", "run"));
    }
}

