/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindManager;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.cli.InstallUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.core.connection.RemoteConnection;
import org.eclipse.codewind.intellij.core.constants.AppStatus;
import org.eclipse.codewind.intellij.core.constants.BuildStatus;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;

public class CodewindTreeNodeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setIcons(value);
        String text = this.getText(value);
        super.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    private void setIcons(Object value) {
        if (value instanceof ConnectionManager || value instanceof String) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/codewind.svg");
            this.setIcons(icon);
            return;
        }
        if (value instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)value;
            Icon icon = IconCache.getCachedIcon("/icons/themed/local_disconnected.svg");
            if (connection.isConnected()) {
                icon = IconCache.getCachedIcon("/icons/themed/local_connected.svg");
            }
            this.setIcons(icon);
            return;
        }
        if (!(value instanceof CodewindApplication)) {
            return;
        }
        CodewindApplication app = (CodewindApplication)value;
        ProjectType type = app.projectType;
        if (type == ProjectType.TYPE_LIBERTY) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/microprofile.svg");
            this.setIcons(icon);
            return;
        }
        if (type == ProjectType.TYPE_NODEJS) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/nodejs.svg");
            this.setIcons(icon);
            return;
        }
        if (type == ProjectType.TYPE_SPRING) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/spring.svg");
            this.setIcons(icon);
            return;
        }
        if (type == ProjectType.TYPE_SWIFT) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/swift.svg");
            this.setIcons(icon);
            return;
        }
        ProjectLanguage lang = app.projectLanguage;
        if (lang.isGo()) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/go.svg");
            this.setIcons(icon);
        } else if (lang.isJava()) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/java.svg");
            this.setIcons(icon);
        } else if (lang.isJavaScript()) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/nodejs.svg");
            this.setIcons(icon);
        } else if (lang.isPython()) {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/python.svg");
            this.setIcons(icon);
        } else {
            Icon icon = IconCache.getCachedIcon("/icons/themeless/project-types/generic.svg");
            this.setIcons(icon);
        }
    }

    private void setIcons(Icon icon) {
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
    }

    @NotNull
    private String getText(Object element) {
        if (element instanceof ConnectionManager) {
            return this.getText((ConnectionManager)element);
        }
        if (element instanceof CodewindConnection) {
            return this.getText((CodewindConnection)element);
        }
        if (element instanceof CodewindApplication) {
            CodewindApplication application = (CodewindApplication)element;
            return this.getText(application);
        }
        String string = element.toString();
        if (string == null) {
            CodewindTreeNodeCellRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private String getText(CodewindApplication application) {
        StringBuilder builder = new StringBuilder(application.name);
        if (application.isEnabled()) {
            AppStatus appStatus = application.getAppStatus();
            BuildStatus buildStatus = application.getBuildStatus();
            if (appStatus == AppStatus.UNKNOWN && buildStatus == BuildStatus.UNKOWN) {
                builder.append(" [").append(AppStatus.UNKNOWN.displayString).append("]");
            }
            if (appStatus != AppStatus.UNKNOWN) {
                String displayString = appStatus.getDisplayString(application.getStartMode());
                builder.append(" [").append(displayString).append("]");
            }
            if (buildStatus != BuildStatus.UNKOWN) {
                String buildDetails = application.getBuildDetails();
                if (buildDetails != null && !buildDetails.isEmpty()) {
                    builder.append(" [").append(buildStatus.getDisplayString()).append(": ").append(buildDetails).append("]");
                } else {
                    builder.append(" [").append(buildStatus.getDisplayString()).append("]");
                }
            }
        } else {
            builder.append(" [").append(CodewindUIBundle.message("CodewindProjectDisabled", new Object[0])).append("]");
        }
        String string = builder.toString();
        if (string == null) {
            CodewindTreeNodeCellRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private String getText(CodewindConnection connection) {
        if (connection instanceof LocalConnection) {
            return this.getText((LocalConnection)connection);
        }
        return this.getText((RemoteConnection)connection);
    }

    @NotNull
    private String getText(LocalConnection connection) {
        String text = connection.getName();
        CodewindManager manager = CodewindManager.getManager();
        CodewindManager.InstallerStatus installerStatus = manager.getInstallerStatus();
        if (installerStatus != null) {
            switch (installerStatus) {
                case INSTALLING: {
                    String string = text + " [" + CodewindUIBundle.message("CodewindInstallingQualifier", new Object[0]) + "]";
                    if (string == null) {
                        CodewindTreeNodeCellRenderer.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                case UNINSTALLING: {
                    String string = text + " [" + CodewindUIBundle.message("CodewindUninstallingQualifier", new Object[0]) + "]";
                    if (string == null) {
                        CodewindTreeNodeCellRenderer.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                case STARTING: {
                    String string = text + " [" + CodewindUIBundle.message("CodewindStartingQualifier", new Object[0]) + "]";
                    if (string == null) {
                        CodewindTreeNodeCellRenderer.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                case STOPPING: {
                    String string = text + " [" + CodewindUIBundle.message("CodewindStoppingQualifier", new Object[0]) + "]";
                    if (string == null) {
                        CodewindTreeNodeCellRenderer.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            }
        } else {
            InstallStatus status = manager.getInstallStatus();
            if (status.isStarted()) {
                String string = text + " [" + CodewindUIBundle.message("CodewindRunningQualifier", new Object[0]) + "]";
                if (string == null) {
                    CodewindTreeNodeCellRenderer.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (status.isInstalled()) {
                if (status.hasStartedVersions()) {
                    String string = text + " [" + CodewindUIBundle.message("CodewindWrongVersionQualifier", status.getStartedVersions()) + "] (" + CodewindUIBundle.message("CodewindWrongVersionMsg", InstallUtil.getVersion());
                    if (string == null) {
                        CodewindTreeNodeCellRenderer.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                String string = text + " [" + CodewindUIBundle.message("CodewindNotStartedQualifier", new Object[0]) + "] (" + CodewindUIBundle.message("CodewindNotStartedMsg", new Object[0]) + ")";
                if (string == null) {
                    CodewindTreeNodeCellRenderer.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (status.hasInstalledVersions()) {
                String string = text + " [" + CodewindUIBundle.message("CodewindWrongVersionQualifier", status.getInstalledVersions()) + "] (" + CodewindUIBundle.message("CodewindWrongVersionMsg", InstallUtil.getVersion());
                if (string == null) {
                    CodewindTreeNodeCellRenderer.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (status.isError()) {
                String msg = manager.getInstallerErrorMsg();
                if (msg != null) {
                    Logger.log(msg);
                }
                String string = text + " [" + CodewindUIBundle.message("CodewindErrorQualifier", new Object[0]) + "] (" + CodewindUIBundle.message("CodewindErrorMsg", new Object[0]) + ")";
                if (string == null) {
                    CodewindTreeNodeCellRenderer.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (status.isUnknown()) {
                String string = text + " [ " + CodewindUIBundle.message("RefreshingCodewindStatus", new Object[0]) + " ]";
                if (string == null) {
                    CodewindTreeNodeCellRenderer.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = text + " [" + CodewindUIBundle.message("CodewindNotInstalledQualifier", new Object[0]) + "] (" + CodewindUIBundle.message("CodewindNotInstalledMsg", new Object[0]) + ")";
            if (string == null) {
                CodewindTreeNodeCellRenderer.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            CodewindTreeNodeCellRenderer.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String getText(RemoteConnection connection) {
        return "";
    }

    @NotNull
    private String getText(ConnectionManager manager) {
        String string = CodewindUIBundle.message("CodewindLabel", new Object[0]);
        if (string == null) {
            CodewindTreeNodeCellRenderer.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/tree/CodewindTreeNodeCellRenderer", "getText"));
    }
}

