/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.cli;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.core.cli.CLIUtil;
import org.eclipse.codewind.intellij.core.cli.ConnectionInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionUtil {
    private static final String CONNECTIONS_CMD = "connections";
    private static final String[] LIST_CMD = new String[]{"connections", "list"};
    private static final String[] ADD_CMD = new String[]{"connections", "add"};
    private static final String[] REMOVE_CMD = new String[]{"connections", "remove"};
    private static final String[] UPDATE_CMD = new String[]{"connections", "update"};
    private static final String LABEL_OPTION = "--label";
    private static final String URL_OPTION = "--url";
    private static final String USERNAME_OPTION = "--username";
    private static final String ID_KEY = "id";

    public static List<ConnectionInfo> listConnections(ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = ConnectionUtil.runConnectionCmd(LIST_CMD, null, null, true, monitor);
        JSONObject resultJson = new JSONObject(result.getOutput());
        return ConnectionInfo.getInfos(resultJson);
    }

    public static String addConnection(String name, String url, String username, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = ConnectionUtil.runConnectionCmd(ADD_CMD, new String[]{LABEL_OPTION, name, URL_OPTION, url, USERNAME_OPTION, username}, null, true, monitor);
        JSONObject resultJson = new JSONObject(result.getOutput());
        return resultJson.getString(ID_KEY);
    }

    public static void removeConnection(String conid, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        ConnectionUtil.runConnectionCmd(REMOVE_CMD, new String[]{"--conid", conid}, null, false, monitor);
    }

    public static void updateConnection(String conid, String name, String url, String username, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        ConnectionUtil.runConnectionCmd(UPDATE_CMD, new String[]{"--conid", conid, LABEL_OPTION, name, URL_OPTION, url, USERNAME_OPTION, username}, null, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessHelper.ProcessResult runConnectionCmd(String[] command, String[] options, String[] args, boolean checkOutput, ProgressIndicator monitor) throws IOException, JSONException, TimeoutException {
        monitor.setIndeterminate(true);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, command, options, args);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60);
            CLIUtil.checkResult(command, result, checkOutput);
            ProcessHelper.ProcessResult processResult = result;
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

