/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.console;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ui.content.Content;
import java.io.IOException;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindSocket;
import org.eclipse.codewind.intellij.core.console.ILogChangeNotifier;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;

public class SocketConsole {
    public final CodewindApplication app;
    public final ProjectLogInfo logInfo;
    private final CodewindSocket socket;
    private String consoleName;
    private boolean isInitialized = false;
    private Content content;
    private ConsoleView consoleView;
    private final ILogChangeNotifier notifier;

    public SocketConsole(Content content, ConsoleView consoleView, String consoleName, ProjectLogInfo logInfo, CodewindApplication app, ILogChangeNotifier iLogChangeNotifier) {
        this.logInfo = logInfo;
        this.app = app;
        this.socket = app.connection.getSocket();
        this.content = content;
        this.consoleView = consoleView;
        this.consoleName = consoleName;
        this.notifier = iLogChangeNotifier;
    }

    public void initialize() throws Exception {
        final SocketConsole socketConsole = this;
        CoreUtil.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    SocketConsole.this.socket.registerSocketConsole(socketConsole);
                    SocketConsole.this.app.connection.requestEnableLogStream(SocketConsole.this.app, SocketConsole.this.logInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String contents, boolean reset) throws IOException {
        if (!this.isInitialized || reset) {
            if (this.consoleView != null) {
                this.consoleView.clear();
            }
            this.isInitialized = true;
        }
        if (!this.consoleView.getComponent().isShowing()) {
            ILogChangeNotifier iLogChangeNotifier = this.notifier;
            synchronized (iLogChangeNotifier) {
                this.notifier.notifyChange(this.consoleName);
            }
        }
        this.consoleView.print(contents, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void dispose() {
        Logger.log("Dispose console " + this.logInfo.logName);
        this.socket.deregisterSocketConsole(this);
        if (this.app.isAvailable()) {
            try {
                this.app.connection.requestDisableLogStream(this.app, this.logInfo);
            }
            catch (Exception e) {
                Logger.logWarning("Error disabling the log stream for: " + this.app.name, e);
            }
        }
    }
}

