/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.ide.actions.NewProjectAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.module.CodewindModuleBuilder;
import org.jetbrains.annotations.NotNull;

public class NewCodewindProjectAction
extends NewProjectAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NewCodewindProjectAction.$$$reportNull$$$0(0);
        }
        CodewindConnection connection = this.getSelection(e);
        NewProjectWizard wizard = new NewProjectWizard(null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
        try {
            ProjectBuilder projectBuilder = wizard.getProjectBuilder();
            if (projectBuilder instanceof CodewindModuleBuilder) {
                CodewindModuleBuilder moduleBuilder = (CodewindModuleBuilder)projectBuilder;
                moduleBuilder.setConnection(connection);
            }
            this.selectCodewindTemplate(wizard);
        }
        catch (Exception ex) {
            Logger.logWarning(ex);
        }
        NewProjectUtil.createNewProject((AbstractProjectWizard)wizard);
    }

    private void selectCodewindTemplate(NewProjectWizard wizard) {
        List steps = wizard.getSequence().getAllSteps();
        for (ModuleWizardStep step : steps) {
            if (!(step instanceof ProjectTypeStep)) continue;
            ProjectTypeStep projectTypeStep = (ProjectTypeStep)step;
            if (projectTypeStep.getPreferredFocusedComponent() instanceof JBList) {
                JBList list = (JBList)projectTypeStep.getPreferredFocusedComponent();
                ListModel model = list.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    TemplatesGroup group = (TemplatesGroup)model.getElementAt(i);
                    if (!"CODEWIND_MODULE".equals(group.getId())) continue;
                    list.setSelectedIndex(i);
                    return;
                }
            }
            return;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewCodewindProjectAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        CodewindConnection connection = this.getSelection(e);
        e.getPresentation().setText(CodewindUIBundle.message("NewProjectAction_Label", new Object[0]), true);
        e.getPresentation().setEnabled(connection != null && connection.isConnected());
    }

    private CodewindConnection getSelection(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            NewCodewindProjectAction.$$$reportNull$$$0(2);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            return null;
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            Logger.log("No selection path for NewCodewindProjectAction: " + tree);
            return null;
        }
        Object node = treePath.getLastPathComponent();
        if (!(node instanceof CodewindConnection)) {
            return null;
        }
        return (CodewindConnection)node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/NewCodewindProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

