/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates.form;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Base64;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.IAuthInfo;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.form.WizardHeaderForm;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.wizard.BaseCodewindForm;
import org.jetbrains.annotations.NotNull;

public class AuthForm
extends BaseCodewindForm {
    private JPanel contentPane;
    private JPanel authenticationMethodPanel;
    private JRadioButton logonRadioButton;
    private JPanel logonPanel;
    private JRadioButton tokenRadioButton;
    private JPanel tokenPanel;
    private JLabel usernameLabel;
    private JTextField usernameTextField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JLabel tokenLabel;
    private JPanel headerPanel;
    private JPanel mainContent;
    private JPanel buttonRow;
    private JButton testButton;
    private JPasswordField tokenField;
    private CodewindConnection connection;
    private Project project;
    private String urlValue;
    private boolean isLogonMethod;
    private String usernameValue;
    private String passwordValue;
    private String tokenValue;
    private boolean showHeader;
    public static String AUTH_FAILED = "AUTH_FAILED";
    public static String AUTH_SUCCESSFUL = "AUTH_SUCCESSFUL";

    public AuthForm(Project project, CodewindConnection connection, boolean isLogonMethod, boolean showHeader) {
        this.project = project;
        this.connection = connection;
        this.isLogonMethod = isLogonMethod;
        this.showHeader = showHeader;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        WizardHeaderForm headerForm = new WizardHeaderForm(CodewindUIBundle.message("AddRepoDialogAuthentication", new Object[0]), CodewindUIBundle.message("AddRepoAuthPageMessage", new Object[0]));
        this.headerPanel = headerForm.getContentPane();
        this.headerPanel.setVisible(this.showHeader);
        this.authenticationMethodPanel = new JPanel();
        this.authenticationMethodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Authentication method"));
        this.logonRadioButton = new JBRadioButton();
        this.logonRadioButton.setText(CodewindUIBundle.message("AddRepoDialogLogonAuthButton", new Object[0]));
        this.tokenRadioButton = new JBRadioButton();
        this.tokenRadioButton.setText(CodewindUIBundle.message("AddRepoDialogAccessTokenAuthButton", new Object[0]));
        this.usernameTextField = new JBTextField();
        this.passwordField = new JBPasswordField();
        this.tokenField = new JBPasswordField();
        this.usernameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AuthForm.this.updateAuthValues();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/templates/form/AuthForm$1", "textChanged"));
            }
        });
        this.passwordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                AuthForm.this.updateAuthValues();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/templates/form/AuthForm$2", "textChanged"));
            }
        });
        this.tokenField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AuthForm.this.updateAuthValues();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.logonRadioButton);
        buttonGroup.add(this.tokenRadioButton);
        if (this.isLogonMethod) {
            this.logonRadioButton.setSelected(true);
            this.tokenField.setEnabled(false);
            this.usernameTextField.setEnabled(true);
            this.passwordField.setEnabled(true);
        } else {
            this.tokenRadioButton.setSelected(true);
            this.tokenField.setEnabled(true);
            this.usernameTextField.setEnabled(false);
            this.passwordField.setEnabled(false);
        }
        this.logonRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AuthForm.this.isLogonMethod = true;
                AuthForm.this.tokenField.setEnabled(false);
                AuthForm.this.usernameTextField.setEnabled(true);
                AuthForm.this.passwordField.setEnabled(true);
            }
        });
        this.tokenRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AuthForm.this.isLogonMethod = false;
                AuthForm.this.tokenField.setEnabled(true);
                AuthForm.this.usernameTextField.setEnabled(false);
                AuthForm.this.passwordField.setEnabled(false);
            }
        });
        this.testButton = new JButton();
        this.testButton.setText(CodewindUIBundle.message("AddRepoDialogTestButtonLabel", new Object[0]));
        this.testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    ThrowableComputable computable = new ThrowableComputable(){

                        public Object compute() throws Exception {
                            HttpUtil.HttpResult result = null;
                            try {
                                result = HttpUtil.get(new URI(AuthForm.this.urlValue), AuthForm.this.getAuthInfo());
                                if (!result.isGoodResponse) {
                                    String errorMsg = result.error;
                                    if (errorMsg == null || errorMsg.trim().isEmpty()) {
                                        errorMsg = CodewindUIBundle.message("AddRepoDialogTestFailedDefaultMsg", result.responseCode);
                                    }
                                    throw new InvocationTargetException(new IOException(errorMsg));
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e, e.toString());
                            }
                            return result;
                        }
                    };
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, CodewindUIBundle.message("AddRepoDialogAuthTestTaskLabel", AuthForm.this.urlValue), true, AuthForm.this.project);
                    CoreUtil.openDialog(false, CodewindUIBundle.message("AddRepoDialogAuthTestFailedTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogTestSuccessMsg", new Object[0]));
                    AuthForm.this.fireStateChanged(new ChangeEvent(AUTH_SUCCESSFUL));
                }
                catch (Exception e) {
                    String msg = e instanceof InvocationTargetException ? e.getCause().toString() : e.toString();
                    CoreUtil.openDialog(true, CodewindUIBundle.message("AddRepoDialogTestFailedTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogAuthTestFailedError", AuthForm.this.urlValue, msg));
                    AuthForm.this.fireStateChanged(new ChangeEvent(AUTH_FAILED));
                    return;
                }
            }
        });
    }

    public IAuthInfo getAuthInfo() {
        return this.isLogonMethod ? new LogonAuth(this.usernameValue, this.passwordValue) : new TokenAuth(this.tokenValue);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public String getUsername() {
        if (this.logonRadioButton.isSelected()) {
            return this.usernameTextField.getText();
        }
        return null;
    }

    public String getPassword() {
        if (this.logonRadioButton.isSelected()) {
            return WidgetUtils.getPassword(this.passwordField);
        }
        return null;
    }

    public String getToken() {
        if (this.tokenRadioButton.isSelected()) {
            return WidgetUtils.getPassword(this.tokenField);
        }
        return null;
    }

    public void setUrlValue(String url) {
        this.urlValue = url;
    }

    public void setEnabled(boolean isEnabled) {
        this.authenticationMethodPanel.setEnabled(isEnabled);
        this.buttonRow.setEnabled(isEnabled);
        this.contentPane.setEnabled(isEnabled);
        this.logonRadioButton.setEnabled(isEnabled);
        this.tokenRadioButton.setEnabled(isEnabled);
        this.usernameLabel.setEnabled(isEnabled);
        this.passwordLabel.setEnabled(isEnabled);
        this.tokenLabel.setEnabled(isEnabled);
        this.usernameTextField.setEnabled(isEnabled && this.logonRadioButton.isSelected());
        this.passwordField.setEnabled(isEnabled && this.logonRadioButton.isSelected());
        this.tokenField.setEnabled(isEnabled && this.tokenRadioButton.isSelected());
    }

    private void updateAuthValues() {
        this.isLogonMethod = this.logonRadioButton.isSelected();
        if (this.isLogonMethod) {
            this.usernameValue = WidgetUtils.getTextValue(this.usernameTextField);
            this.passwordValue = WidgetUtils.getTextValue(this.passwordField);
        } else {
            this.tokenValue = WidgetUtils.getTextValue(this.tokenField);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = this.headerPanel;
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.mainContent = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = this.authenticationMethodPanel;
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JRadioButton jRadioButton = this.logonRadioButton;
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogLogonAuthButton"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.logonPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.usernameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogUsernameLabel"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField = this.usernameTextField;
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.passwordLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogPasswordLabel"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPasswordField jPasswordField = this.passwordField;
        jPanel3.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JRadioButton jRadioButton2 = this.tokenRadioButton;
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogAccessTokenAuthButton"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.tokenPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.tokenLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogAccessTokenLabel"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPasswordField jPasswordField2 = this.tokenField;
        jPanel2.add((Component)jPasswordField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.buttonRow = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JButton jButton = this.testButton;
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AddRepoDialogTestButtonLabel"));
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class TokenAuth
    implements IAuthInfo {
        private final String token;

        public TokenAuth(String token) {
            this.token = token;
        }

        @Override
        public boolean isValid() {
            return this.token != null;
        }

        @Override
        public String getHttpAuthorization() {
            return "bearer " + this.token;
        }
    }

    public static class LogonAuth
    implements IAuthInfo {
        private final String username;
        private final String password;

        public LogonAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public boolean isValid() {
            return this.username != null && this.password != null;
        }

        @Override
        public String getHttpAuthorization() {
            try {
                String auth = this.username + ":" + this.password;
                return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.logWarning("An unsupported encoding exception occurred trying to encode the logon authentication.");
                return null;
            }
        }
    }
}

