/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.wizard;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtil;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ProjectTypeInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.AbstractCodewindWizard;
import org.eclipse.codewind.intellij.ui.wizard.BindProjectModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AddExistingProjectWizard
extends AbstractCodewindWizard {
    private BindProjectModel model;
    private CodewindConnection connection;
    private Project intellijProject;
    private boolean doBind = true;
    private Exception validationException = null;
    private Exception bindException = null;

    public AddExistingProjectWizard(String title, @Nullable Project project, List<? extends AbstractBindProjectWizardStep> steps, @Nullable CodewindConnection connection) {
        super(title, project, steps, "https://www.eclipse.org/codewind/intellij-getting-started.html");
        this.connection = connection;
        this.intellijProject = project;
        this.model = new BindProjectModel();
    }

    protected void doNextAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        AbstractBindProjectWizardStep nextStepObject = (AbstractBindProjectWizardStep)this.getNextStepObject();
        nextStepObject.onStepEntering(this.model);
        super.doNextAction();
        nextStepObject.postDoNextStep(this.model);
    }

    protected void doPreviousAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        super.doPreviousAction();
    }

    @Override
    protected void doOKAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        final String name = PathUtil.getFileName((String)this.model.getProjectPath());
        this.doBind = true;
        ProjectInfo projectInfo = this.model.getProjectInfo();
        final ProjectTypeInfo typeInfo = this.model.getProjectTypeInfo();
        final String path = this.model.getProjectPath();
        this.bindException = null;
        if (projectInfo != null && projectInfo.type.getId().equals(typeInfo.getId())) {
            this.continueWithBind(name, path, projectInfo.language.getId(), typeInfo);
        } else {
            ProjectTypeInfo.ProjectSubtypeInfo subtypeInfo = this.model.getSubtypeInfo();
            this.validationException = null;
            String language = null;
            if (projectInfo != null) {
                language = projectInfo.language.getId();
            }
            if (subtypeInfo != null) {
                language = subtypeInfo.id;
            }
            if (language == null) {
                language = ProjectLanguage.LANGUAGE_JAVA.getId();
            }
            final String finalLanguage = language;
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        ProjectUtil.validateProject(name, path, typeInfo.getId() + ":" + finalLanguage, AddExistingProjectWizard.this.connection.getConid(), indicator);
                    }
                    catch (Exception e) {
                        Logger.log(e);
                        AddExistingProjectWizard.this.validationException = e;
                    }
                }
            }, CodewindUIBundle.message("ProjectValidationTask", name), false, this.intellijProject);
            if (this.validationException != null) {
                CoreUtil.invokeLater(() -> {
                    int rc1 = CoreUtil.showYesNoDialog(CodewindUIBundle.message("ProjectValidationTitle", new Object[0]), CodewindUIBundle.message("ProjectValidationFailedContinueProjectBind", this.validationException.getMessage()));
                    if (rc1 == 0) {
                        this.continueWithBind(name, path, finalLanguage, typeInfo);
                    } else {
                        this.doBind = false;
                    }
                });
            }
            if (this.doBind && this.validationException == null) {
                this.continueWithBind(name, path, finalLanguage, typeInfo);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private void continueWithBind(final String name, final String path, final String language, final ProjectTypeInfo typeInfo) {
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        ProjectUtil.bindProject(name, path, language, typeInfo.getId(), AddExistingProjectWizard.this.connection.getConid(), indicator);
                    }
                    catch (Exception e) {
                        Logger.log(e);
                        AddExistingProjectWizard.this.bindException = e;
                    }
                }
            }, CodewindUIBundle.message("BindProjectWizardJobLabel", name), true, this.intellijProject);
        }
        catch (Exception e) {
            Logger.log(e);
        }
        super.doOKAction();
        if (this.bindException != null) {
            CoreUtil.openDialog(true, CodewindUIBundle.message("BindProjectWizardTitle", new Object[0]), CodewindUIBundle.message("BindProjectWizardError", name));
            return;
        }
        try {
            String selectedProjectPath = this.model.getProjectPath();
            Project[] openedProjects = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < openedProjects.length; ++i) {
                Project openedProject = openedProjects[i];
                @SystemIndependent String basePath = openedProject.getBasePath();
                if (!selectedProjectPath.equals(basePath)) continue;
                JFrame frame = WindowManager.getInstance().getFrame(openedProject);
                if (frame != null) {
                    frame.setVisible(true);
                }
                return;
            }
            CoreUtil.invokeLater(() -> {
                Project targetProject = com.intellij.ide.impl.ProjectUtil.openOrImport((String)this.model.getProjectPath(), (Project)this.intellijProject, (boolean)false);
                if (targetProject != null) {
                    CodewindToolWindowHelper.openWindow(targetProject);
                }
            });
        }
        catch (Exception ex) {
            Logger.log(ex);
        }
    }
}

