"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const FileChangeEventBatchUtil_1 = require("./FileChangeEventBatchUtil");
const log = require("./Logger");
class ProjectObject {
    constructor(projectId, projectToWatch, parent) {
        this._projectToWatch = projectToWatch;
        this._batchUtil = new FileChangeEventBatchUtil_1.FileChangeEventBatchUtil(projectId, parent);
    }
    updateProjectToWatch(newProjectToWatch) {
        const existingProjectToWatch = this._projectToWatch;
        if (existingProjectToWatch.pathToMonitor !== newProjectToWatch.pathToMonitor) {
            const msg = "The path to monitor of a project cannot be changed once it set, for a particular project id";
            log.severe(msg);
        }
        this._projectToWatch = newProjectToWatch;
    }
    get projectToWatch() {
        return this._projectToWatch;
    }
    get batchUtil() {
        return this._batchUtil;
    }
}
exports.ProjectObject = ProjectObject;
