/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { ChangedFileEntry } from "./ChangedFileEntry";
import { FileWatcher } from "./FileWatcher";
export declare class FileChangeEventBatchUtil {
    private static readonly TIME_TO_WAIT_FOR_NO_NEW_EVENTS_IN_MSECS;
    private static readonly MAX_REQUEST_SIZE_IN_PATHS;
    private _files;
    private _timer;
    private _disposed;
    private readonly _parent;
    private readonly _projectId;
    constructor(projectId: string, parent: FileWatcher);
    /**
     * When files have changed, add them to the list and reset the timer task ahead
     * X millseconds.
     */
    addChangedFiles(changedFileEntries: ChangedFileEntry[]): void;
    dispose(): void;
    private doTimerTask;
    private generateChangeListSummaryForDebug;
    /** For any given path: If there are multiple entries of the same type in a row, then remove all but the first. */
    private removeDuplicateEventsOfType;
}
