/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.filewatchers.eclipse.CodewindFilewatcherdConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class CodewindResourceChangeListener
implements IResourceChangeListener {
    private final CodewindFilewatcherdConnection parent;

    public CodewindResourceChangeListener(CodewindFilewatcherdConnection parent) {
        this.parent = parent;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        CodewindResourceDeltaVisitor visitor = new CodewindResourceDeltaVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
            visitor.getResult().forEach(e -> System.out.println(e));
            this.parent.handleResourceChanges(visitor.getResult());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private class CodewindResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final List<CodewindFilewatcherdConnection.FileChangeEntryEclipse> result = new ArrayList<CodewindFilewatcherdConnection.FileChangeEntryEclipse>();

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            if (delta.getKind() == 4 && delta.getFlags() == 0) {
                return true;
            }
            CodewindFilewatcherdConnection.FileChangeEntryEclipse.ChangeEntryEventType ceet = null;
            switch (delta.getKind()) {
                case 1: {
                    ceet = CodewindFilewatcherdConnection.FileChangeEntryEclipse.ChangeEntryEventType.CREATE;
                    break;
                }
                case 2: {
                    ceet = CodewindFilewatcherdConnection.FileChangeEntryEclipse.ChangeEntryEventType.DELETE;
                    break;
                }
                case 4: {
                    ceet = CodewindFilewatcherdConnection.FileChangeEntryEclipse.ChangeEntryEventType.MODIFY;
                    break;
                }
            }
            if (ceet == null) {
                return true;
            }
            if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x40000) == 0) {
                return true;
            }
            File resourceFile = resource.getLocation().toFile();
            IProject project = resource.getProject();
            CodewindFilewatcherdConnection.FileChangeEntryEclipse fcee = new CodewindFilewatcherdConnection.FileChangeEntryEclipse(resourceFile, ceet, resource.getType() == 2, project);
            this.result.add(fcee);
            return true;
        }

        public List<CodewindFilewatcherdConnection.FileChangeEntryEclipse> getResult() {
            return this.result;
        }
    }
}

