/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.net.URL;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppState;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenAppMonitorAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public OpenAppMonitorAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ActionOpenAppMonitor);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable() && this.app.getAppState() == AppState.STARTED);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"OpenAppMonitorAction ran but no application was selected");
            return;
        }
        if (!this.app.isRunning()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.OpenAppAction_CantOpenNotRunningAppTitle, (String)Messages.OpenAppAction_CantOpenNotRunningAppMsg);
            return;
        }
        URL url = this.app.getMetricsUrl();
        if (url == null) {
            Logger.logError((String)"OpenAppMonitorAction ran but could not construct the url");
            return;
        }
        try {
            IWebBrowser browser = null;
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            if (CoreUtil.isWindows()) {
                browser = browserSupport.getExternalBrowser();
            }
            if (browser == null) {
                browser = browserSupport.createBrowser(6, this.app.projectID + "_" + "monitor", this.app.name, NLS.bind((String)Messages.BrowserTooltipAppMonitor, (Object)this.app.name));
            }
            browser.openURL(url);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Error opening the app monitor in browser", (Throwable)e);
        }
    }

    public boolean showAction() {
        return this.app != null && this.app.getMetricsAvailable() && this.app.projectLanguage.getMetricsRoot() != null;
    }
}

