/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class UnbindProjectAction
extends SelectionProviderAction {
    CodewindEclipseApplication app;

    public UnbindProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.UnbindActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"UnbindProjectAction ran but no application was selected");
            return;
        }
        if (CoreUtil.openConfirmDialog((String)Messages.UnbindActionTitle, (String)NLS.bind((String)Messages.UnbindActionMessage, (Object)this.app.name))) {
            Job job = new Job(NLS.bind((String)Messages.UnbindActionJobTitle, (Object)this.app.name)){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        UnbindProjectAction.this.app.connection.requestProjectUnbind(UnbindProjectAction.this.app.projectID);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        Logger.logError((String)("Error requesting application remove: " + UnbindProjectAction.this.app.name), (Throwable)e);
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.UnbindActionError, (Object)UnbindProjectAction.this.app.name), (Throwable)e);
                    }
                }
            };
            job.schedule();
        }
    }
}

