/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

public class CodewindPrefsParentPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static IPreferenceStore prefs;
    private Text debugTimeoutText;
    private Combo webBrowserCombo;
    private Text selectWebBrowserLabel;
    private Button[] stopAppsButtons = new Button[3];
    private String browserName = null;

    public void init(IWorkbench arg0) {
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Label stopAppContainersLabel = new Label(composite, 0);
        stopAppContainersLabel.setText(Messages.PrefsParentPage_StopAppsLabel);
        stopAppContainersLabel.setLayoutData((Object)new GridData(1, 4, false, false, 2, 1));
        Composite stopAppsComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 20;
        layout.marginHeight = 2;
        layout.numColumns = 3;
        stopAppsComposite.setLayout((Layout)layout);
        stopAppsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.stopAppsButtons[0] = new Button(stopAppsComposite, 16);
        this.stopAppsButtons[0].setText(Messages.PrefsParentPage_StopAppsAlways);
        this.stopAppsButtons[0].setData((Object)"stopAppContainersAlways");
        this.stopAppsButtons[1] = new Button(stopAppsComposite, 16);
        this.stopAppsButtons[1].setText(Messages.PrefsParentPage_StopAppsNever);
        this.stopAppsButtons[1].setData((Object)"stopAppContainersNever");
        this.stopAppsButtons[2] = new Button(stopAppsComposite, 16);
        this.stopAppsButtons[2].setText(Messages.PrefsParentPage_StopAppsPrompt);
        this.stopAppsButtons[2].setData((Object)"stopAppContainersPrompt");
        this.setStopAppsSelection(prefs.getString("stopAppContainers"));
        Label separator = new Label(composite, 256);
        separator.setLayoutData((Object)new GridData(768, 2, true, false, 2, 1));
        Label debugTimeoutLabel = new Label(composite, 8);
        debugTimeoutLabel.setText(Messages.PrefsParentPage_DebugTimeoutLabel);
        debugTimeoutLabel.setLayoutData((Object)new GridData(1, 4, false, false));
        this.debugTimeoutText = new Text(composite, 2048);
        this.debugTimeoutText.setTextLimit(3);
        this.debugTimeoutText.setText("" + prefs.getInt("serverDebugTimeout"));
        GridData debugTextData = new GridData(1, 4, false, false);
        debugTextData.widthHint = 50;
        this.debugTimeoutText.setLayoutData((Object)debugTextData);
        this.debugTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindPrefsParentPage.this.validate();
            }
        });
        separator = new Label(composite, 256);
        separator.setLayoutData((Object)new GridData(768, 2, true, false, 2, 1));
        Text browserSelectionLabel = new Text(composite, 12);
        browserSelectionLabel.setText(Messages.BrowserSelectionLabel);
        browserSelectionLabel.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        browserSelectionLabel.setBackground(composite.getBackground());
        browserSelectionLabel.setForeground(composite.getForeground());
        Composite selectWebBrowserComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 20;
        layout.marginHeight = 2;
        layout.numColumns = 3;
        selectWebBrowserComposite.setLayout((Layout)layout);
        selectWebBrowserComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.selectWebBrowserLabel = new Text(selectWebBrowserComposite, 12);
        this.selectWebBrowserLabel.setText(Messages.BrowserSelectionListLabel);
        this.selectWebBrowserLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.selectWebBrowserLabel.setBackground(selectWebBrowserComposite.getBackground());
        this.selectWebBrowserLabel.setForeground(selectWebBrowserComposite.getForeground());
        this.webBrowserCombo = new Combo(selectWebBrowserComposite, 2056);
        this.refreshPreferencesPage();
        Link addBrowserButton = new Link(selectWebBrowserComposite, 0);
        addBrowserButton.setText("<a href=\"org.eclipse.ui.browser.preferencePage\">" + Messages.BrowserSelectionManageButtonText + "</a>");
        addBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)e.text, null, null);
                composite.layout();
            }
        });
        Label endSpacer = new Label(composite, 0);
        endSpacer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        new Label(composite, 0);
        return composite;
    }

    private void setStopAppsSelection(String selection) {
        for (Button button : this.stopAppsButtons) {
            if (!button.getData().equals(selection)) continue;
            button.setSelection(true);
            break;
        }
    }

    private void validate() {
        String invalidReason = null;
        String timeoutText = this.debugTimeoutText.getText().trim();
        boolean goodDebugTimeout = false;
        try {
            int timeout = Integer.parseInt(timeoutText);
            goodDebugTimeout = timeout > 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!goodDebugTimeout) {
            invalidReason = NLS.bind((String)Messages.PrefsParentPage_ErrInvalidDebugTimeout, (Object)timeoutText);
        }
        this.setErrorMessage(invalidReason);
        this.setValid(invalidReason == null);
    }

    public boolean performOk() {
        if (!this.isValid()) {
            return false;
        }
        for (Button button : this.stopAppsButtons) {
            if (!button.getSelection()) continue;
            prefs.setValue("stopAppContainers", (String)button.getData());
            break;
        }
        int debugTimeout = Integer.parseInt(this.debugTimeoutText.getText().trim());
        prefs.setValue("serverDebugTimeout", debugTimeout);
        this.debugTimeoutText.setText("" + debugTimeout);
        if (this.webBrowserCombo != null) {
            if (this.webBrowserCombo.getSelectionIndex() > 0) {
                if (this.browserName != null) {
                    prefs.setValue("nodejsDebugBrowserName", this.browserName);
                }
            } else {
                prefs.setToDefault("nodejsDebugBrowserName");
            }
        }
        return true;
    }

    public void performDefaults() {
        this.setStopAppsSelection(prefs.getDefaultString("stopAppContainers"));
        this.debugTimeoutText.setText("" + prefs.getDefaultInt("serverDebugTimeout"));
        this.webBrowserCombo.select(0);
    }

    protected void refreshPreferencesPage() {
        List browserList;
        if (this.webBrowserCombo == null) {
            return;
        }
        this.webBrowserCombo.removeAll();
        this.webBrowserCombo.add(Messages.BrowserSelectionNoBrowserSelected);
        this.webBrowserCombo.select(0);
        BrowserManager bm = BrowserManager.getInstance();
        if (bm != null && (browserList = bm.getWebBrowsers()) != null) {
            ArrayList<IBrowserDescriptor> validBrowsers = new ArrayList<IBrowserDescriptor>();
            int len = browserList.size();
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)browserList.get(i);
                if (tempBrowser == null || tempBrowser.getLocation() == null || tempBrowser.getLocation().trim().equals("")) continue;
                validBrowsers.add(tempBrowser);
            }
            len = validBrowsers.size();
            Logger.log((String)("Refresh preference page valid browser length: " + len));
            String foundDefaultBrowser = prefs.getString("nodejsDebugBrowserName");
            boolean foundDefaultBrowserName = false;
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)validBrowsers.get(i);
                if (tempBrowser == null) continue;
                String browserName = tempBrowser.getName();
                this.webBrowserCombo.add(browserName);
                if (browserName == null || foundDefaultBrowser == null || !browserName.equalsIgnoreCase(foundDefaultBrowser)) continue;
                this.webBrowserCombo.select(i + 1);
                foundDefaultBrowserName = true;
            }
            Logger.log((String)("Refresh preference page found default browser: " + foundDefaultBrowser));
            if (foundDefaultBrowser == null || !foundDefaultBrowserName) {
                Logger.log((String)"Refresh preference page: could not find preferences or browser was removed");
                prefs.setToDefault("nodejsDebugBrowserName");
            }
            this.webBrowserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CodewindPrefsParentPage.this.webBrowserCombo.getSelectionIndex() >= 0) {
                        CodewindPrefsParentPage.this.browserName = CodewindPrefsParentPage.this.webBrowserCombo.getText();
                    }
                }
            });
        }
        this.webBrowserCombo.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public void setVisible(boolean visible) {
        if (this.webBrowserCombo != null) {
            this.refreshPreferencesPage();
        }
        super.setVisible(visible);
    }
}

