/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.json.JSONObject;

public class HttpUtil {
    private static final int DEFAULT_READ_TIMEOUT_S = 10;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;

    private HttpUtil() {
    }

    public static HttpResult get(URI uri) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(10000);
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResult post(URI uri, JSONObject payload) throws IOException {
        return HttpUtil.post(uri, payload, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult post(URI uri, JSONObject payload, int readTimoutSeconds) throws IOException {
        HttpURLConnection connection = null;
        Logger.log("POST " + payload.toString() + " TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("POST");
            connection.setReadTimeout(readTimoutSeconds * 1000);
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResult post(URI uri) throws IOException {
        HttpURLConnection connection = null;
        Logger.log("Empty POST TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("POST");
            connection.setReadTimeout(10000);
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResult put(URI uri) throws IOException {
        HttpURLConnection connection = null;
        Logger.log("PUT " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("PUT");
            connection.setReadTimeout(10000);
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResult head(URI uri) throws IOException {
        HttpURLConnection connection = null;
        Logger.log("HEAD " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("HEAD");
            connection.setReadTimeout(10000);
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static HttpResult delete(URI uri) throws IOException {
        HttpURLConnection connection = null;
        Logger.log("DELETE " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("DELETE");
            connection.setReadTimeout(10000);
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static class HttpResult {
        public final int responseCode;
        public final boolean isGoodResponse;
        public final String response;
        public final String error;
        private final Map<String, List<String>> headerFields;

        public HttpResult(HttpURLConnection connection) throws IOException {
            this.responseCode = connection.getResponseCode();
            this.isGoodResponse = this.responseCode > 199 && this.responseCode < 300;
            this.headerFields = this.isGoodResponse ? connection.getHeaderFields() : null;
            InputStream eis = connection.getErrorStream();
            this.error = eis != null ? CoreUtil.readAllFromStream(eis) : null;
            if (!this.isGoodResponse) {
                Logger.logError("Received bad response code " + this.responseCode + " from " + connection.getURL() + " - Error:\n" + this.error);
                this.response = null;
            } else {
                InputStream is = connection.getInputStream();
                this.response = is != null ? CoreUtil.readAllFromStream(is) : null;
            }
        }

        public String getHeader(String key) {
            if (this.headerFields == null) {
                return null;
            }
            List<String> list = this.headerFields.get(key);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }
}

