/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindApplicationFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.CodewindSocket;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.codewind.filewatchers.eclipse.CodewindFilewatcherdConnection;
import org.eclipse.codewind.filewatchers.eclipse.ICodewindProjectTranslator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindConnection {
    public static final String CODEWIND_WORKSPACE_PROPERTY = "org.eclipse.codewind.internal.workspace";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String BRANCH_VERSION = "\\d{4}_M\\d{1,2}_\\D";
    private static final Pattern pattern = Pattern.compile("\\d{4}_M\\d{1,2}_\\D");
    public final URI baseUrl;
    private IPath localWorkspacePath;
    private String versionStr;
    private String connectionErrorMsg = null;
    private String socketNamespace = null;
    private CodewindSocket socket;
    private CodewindFilewatcherdConnection filewatcher;
    private volatile boolean isConnected = true;
    private Map<String, CodewindApplication> appMap = new LinkedHashMap<String, CodewindApplication>();

    public static URI buildUrl(String host, int port) throws URISyntaxException {
        return new URI("http", null, host, port, null, null, null);
    }

    public CodewindConnection(URI uri) throws IOException, URISyntaxException, JSONException {
        if (!uri.toString().endsWith("/")) {
            uri = uri.resolve("/");
        }
        this.baseUrl = uri;
        if (CodewindConnectionManager.getActiveConnection(uri.toString()) != null) {
            this.onInitFail(NLS.bind((String)Messages.Connection_ErrConnection_AlreadyExists, (Object)this.baseUrl));
        }
        JSONObject env = CodewindConnection.getEnvData(this.baseUrl);
        this.versionStr = CodewindConnection.getCodewindVersion(env);
        Logger.log("Codewind version is: " + this.versionStr);
        this.localWorkspacePath = CodewindConnection.getWorkspacePath(env);
        if (this.localWorkspacePath == null) {
            this.onInitFail(Messages.Connection_ErrConnection_WorkspaceErr);
        }
        this.socketNamespace = CodewindConnection.getSocketNamespace(env);
        this.socket = new CodewindSocket(this);
        if (!this.socket.blockUntilFirstConnection()) {
            this.close();
            throw new CodewindConnectionException(this.socket.socketUri);
        }
        this.refreshApps(null);
        this.filewatcher = new CodewindFilewatcherdConnection(this.baseUrl.toString(), new ICodewindProjectTranslator(){

            public Optional<String> getProjectId(IProject project) {
                CodewindApplication app;
                if (project != null && (app = CodewindConnection.this.getAppByName(project.getName())) != null) {
                    return Optional.of(app.projectID);
                }
                return Optional.empty();
            }
        });
        Logger.log("Created " + this);
    }

    public String getSocketNamespace() {
        return this.socketNamespace;
    }

    public CodewindSocket getSocket() {
        return this.socket;
    }

    private void onInitFail(String msg) throws ConnectException {
        Logger.log("Initializing Codewind connection failed: " + msg);
        this.close();
        throw new ConnectException(msg);
    }

    public void close() {
        Logger.log("Closing " + this);
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.filewatcher != null) {
            this.filewatcher.dispose();
        }
        for (CodewindApplication app : this.appMap.values()) {
            app.dispose();
        }
    }

    private static JSONObject getEnvData(URI baseUrl) throws JSONException, IOException {
        URI envUrl = baseUrl.resolve("api/v1/environment");
        String envResponse = null;
        try {
            envResponse = HttpUtil.get((URI)envUrl).response;
        }
        catch (IOException e) {
            Logger.logError("Error contacting Environment endpoint", e);
            throw e;
        }
        return new JSONObject(envResponse);
    }

    private static String getCodewindVersion(JSONObject env) {
        if (!env.has("microclimate_version")) {
            Logger.logError("Missing version from env data");
            return UNKNOWN_VERSION;
        }
        try {
            String versionStr = env.getString("microclimate_version");
            Logger.log("Codewind version is: " + versionStr);
            return versionStr;
        }
        catch (JSONException e) {
            Logger.logError(e);
            return UNKNOWN_VERSION;
        }
    }

    private static boolean isSupportedVersion(String versionStr) {
        if (UNKNOWN_VERSION.equals(versionStr)) {
            return false;
        }
        if ("latest".equals(versionStr)) {
            return true;
        }
        Matcher matcher = pattern.matcher(versionStr);
        if (matcher.matches()) {
            return true;
        }
        try {
            int version = Integer.parseInt(versionStr);
            return version >= 1812;
        }
        catch (NumberFormatException e) {
            Logger.logError("Couldn't parse version number from " + versionStr);
            return false;
        }
    }

    public boolean checkVersion(int requiredVersion, String requiredVersionBr) {
        if (UNKNOWN_VERSION.equals(this.versionStr)) {
            return false;
        }
        if ("latest".equals(this.versionStr)) {
            return true;
        }
        Matcher matcher = pattern.matcher(this.versionStr);
        if (matcher.matches()) {
            String actualYear = this.versionStr.substring(0, 4);
            String requiredYear = requiredVersionBr.substring(0, 4);
            try {
                if (Integer.parseInt(actualYear) >= Integer.parseInt(requiredYear)) {
                    int index = this.versionStr.lastIndexOf(95);
                    String actualIteration = this.versionStr.substring(6, index);
                    index = requiredVersionBr.lastIndexOf(95);
                    String requiredIteration = requiredVersionBr.substring(6, index);
                    if (Integer.parseInt(actualIteration) >= Integer.parseInt(requiredIteration)) {
                        return true;
                    }
                }
            }
            catch (NumberFormatException e) {
                Logger.logError("Failed to parse the actual version: " + this.versionStr + ", or the required version: " + requiredVersionBr);
            }
            return false;
        }
        try {
            return Integer.parseInt(this.versionStr) >= requiredVersion;
        }
        catch (NumberFormatException e) {
            Logger.logError("Couldn't parse version number from " + this.versionStr);
            return false;
        }
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    private static Path getWorkspacePath(JSONObject env) throws JSONException {
        String path = System.getProperty(CODEWIND_WORKSPACE_PROPERTY, null);
        if (path != null && !path.isEmpty()) {
            return new Path(path);
        }
        if (!env.has("workspace_location")) {
            Logger.logError("Missing workspace location from env data");
            return null;
        }
        String workspaceLoc = env.getString("workspace_location");
        if (CoreUtil.isWindows() && workspaceLoc.startsWith("/")) {
            String device = workspaceLoc.substring(1, 2);
            workspaceLoc = device + ":" + workspaceLoc.substring(2);
        }
        return new Path(workspaceLoc);
    }

    private static String getSocketNamespace(JSONObject env) throws JSONException {
        String namespace;
        Object nsObj;
        if (env.has("socket_namespace") && (nsObj = env.get("socket_namespace")) instanceof String && !(namespace = (String)nsObj).isEmpty()) {
            return namespace;
        }
        return null;
    }

    public void refreshApps(String projectID) {
        URI projectsURL = this.baseUrl.resolve("api/v1/projects");
        try {
            String projectsResponse = HttpUtil.get((URI)projectsURL).response;
            CodewindApplicationFactory.getAppsFromProjectsJson(this, projectsResponse, projectID);
            Logger.log("App list update success");
        }
        catch (Exception e) {
            CoreUtil.openDialog(true, Messages.Connection_ErrGettingProjectListTitle, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(CodewindApplication app) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.put(app.projectID, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodewindApplication> getApps() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new ArrayList<CodewindApplication>(this.appMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAppIds() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new HashSet<String>(this.appMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String projectID) {
        CodewindApplication app = null;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            app = this.appMap.remove(projectID);
        }
        if (app != null) {
            CoreUtil.removeApplication(app);
            app.dispose();
        } else {
            Logger.logError("No application found for project being deleted: " + projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByID(String projectID) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return this.appMap.get(projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByName(String name) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!app.name.equals(name)) continue;
                return app;
            }
        }
        Logger.log("No application found for name " + name);
        return null;
    }

    public void requestProjectRestart(CodewindApplication app, String launchMode) throws JSONException, IOException {
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + "restart";
        URI url = this.baseUrl.resolve(restartEndpoint);
        JSONObject restartProjectPayload = new JSONObject();
        restartProjectPayload.put("startMode", (Object)launchMode);
        HttpUtil.HttpResult result = HttpUtil.post(url, restartProjectPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        app.invalidatePorts();
    }

    public void requestProjectOpenClose(CodewindApplication app, boolean enable) throws JSONException, IOException {
        String action = enable ? "open" : "close";
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + action;
        URI url = this.baseUrl.resolve(restartEndpoint);
        HttpUtil.HttpResult result = HttpUtil.put(url);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public JSONObject requestProjectStatus(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUrl.resolve("api/v1/projects");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but null response when getting initial state");
        }
        JSONArray allProjectStatuses = new JSONArray(result.response);
        for (int i = 0; i < allProjectStatuses.length(); ++i) {
            JSONObject projectStatus = allProjectStatuses.getJSONObject(i);
            if (!projectStatus.getString("projectID").equals(app.projectID)) continue;
            return projectStatus;
        }
        Logger.log("Didn't find status info for project " + app.name);
        return null;
    }

    public JSONObject requestProjectMetricsStatus(CodewindApplication app) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "metrics/status";
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        return new JSONObject(result.response);
    }

    public void requestProjectBuild(CodewindApplication app, String action) throws JSONException, IOException {
        String buildEndpoint = "api/v1/projects/" + app.projectID + "/" + "build";
        URI url = this.baseUrl.resolve(buildEndpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("action", (Object)action);
        HttpUtil.post(url, buildPayload);
    }

    public List<ProjectLogInfo> requestProjectLogs(CodewindApplication app) throws JSONException, IOException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs";
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        JSONObject logs = new JSONObject(result.response);
        JSONArray buildLogs = logs.getJSONArray("build");
        logList.addAll(CodewindConnection.getLogs(buildLogs, "build"));
        JSONArray appLogs = logs.getJSONArray("app");
        logList.addAll(CodewindConnection.getLogs(appLogs, "app"));
        return logList;
    }

    public static List<ProjectLogInfo> getLogs(JSONArray logs, String type) throws JSONException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        if (logs != null) {
            for (int i = 0; i < logs.length(); ++i) {
                JSONObject log = logs.getJSONObject(i);
                if (log.has("logName")) {
                    String logName = log.getString("logName");
                    if ("-".equals(logName)) continue;
                    String workspacePath = null;
                    if (log.has("workspaceLogPath")) {
                        workspacePath = log.getString("workspaceLogPath");
                    }
                    ProjectLogInfo logInfo = new ProjectLogInfo(type, logName, workspacePath);
                    logList.add(logInfo);
                    continue;
                }
                Logger.log("An item in the log list does not have the key: logName");
            }
        }
        return logList;
    }

    public void requestEnableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri);
        this.checkResult(result, uri, false);
    }

    public void requestDisableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri);
        this.checkResult(result, uri, false);
    }

    public void requestValidate(CodewindApplication app) throws JSONException, IOException {
        boolean projectIdInPath = this.checkVersion(1901, "2019_M1_E");
        String endpoint = projectIdInPath ? "api/v1/projects/" + app.projectID + "/" + "validate" : "api/v1/validate";
        URI url = this.baseUrl.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        if (!projectIdInPath) {
            buildPayload.put("projectID", (Object)app.projectID);
        }
        buildPayload.put("projectType", (Object)app.projectType.getId());
        HttpUtil.HttpResult result = HttpUtil.post(url, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public void requestValidateGenerate(CodewindApplication app) throws JSONException, IOException {
        boolean projectIdInPath = this.checkVersion(1901, "2019_M1_E");
        String endpoint = projectIdInPath ? "api/v1/projects/" + app.projectID + "/" + "validate/generate" : "api/v1/validate/generate";
        URI url = this.baseUrl.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        if (!projectIdInPath) {
            buildPayload.put("projectID", (Object)app.projectID);
        }
        buildPayload.put("projectType", (Object)app.projectType.getId());
        buildPayload.put("autoGenerate", true);
        HttpUtil.HttpResult result = HttpUtil.post(url, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        this.requestValidate(app);
    }

    public JSONObject requestProjectCapabilities(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUrl.resolve("api/v1/projects/" + app.projectID + "/" + "capabilities");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but empty content when getting project capabilities");
        }
        JSONObject capabilities = new JSONObject(result.response);
        return capabilities;
    }

    public List<ProjectTemplateInfo> requestProjectTemplates() throws IOException, JSONException {
        ArrayList<ProjectTemplateInfo> templates = new ArrayList<ProjectTemplateInfo>();
        URI uri = this.baseUrl.resolve("api/v1/templates");
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        JSONArray templateArray = new JSONArray(result.response);
        for (int i = 0; i < templateArray.length(); ++i) {
            templates.add(new ProjectTemplateInfo(templateArray.getJSONObject(i)));
        }
        return templates;
    }

    public ProjectInfo requestProjectValidate(String path) throws JSONException, IOException {
        String endpoint = "api/v1/validate";
        URI uri = this.baseUrl.resolve(endpoint);
        JSONObject createProjectPayload = new JSONObject();
        createProjectPayload.put("projectPath", (Object)CoreUtil.getContainerPath(path));
        HttpUtil.HttpResult result = HttpUtil.post(uri, createProjectPayload);
        this.checkResult(result, uri, false);
        JSONObject resultJson = new JSONObject(result.response);
        if ("success".equals(resultJson.getString("status"))) {
            if (resultJson.has("result")) {
                JSONObject typeJson = resultJson.getJSONObject("result");
                String language = typeJson.getString("language");
                String projectType = typeJson.getString("projectType");
                return new ProjectInfo(projectType, language);
            }
            return null;
        }
        throw new IOException("Validate failed for project: " + path);
    }

    public void requestProjectCreate(ProjectTemplateInfo templateInfo, String name) throws JSONException, IOException {
        String endpoint = "api/v1/projects";
        URI uri = this.baseUrl.resolve(endpoint);
        JSONObject createProjectPayload = new JSONObject();
        createProjectPayload.put("projectName", (Object)name);
        createProjectPayload.put("parentPath", (Object)CoreUtil.getContainerPath(this.localWorkspacePath.toString()));
        createProjectPayload.put("url", (Object)templateInfo.getUrl());
        HttpUtil.HttpResult result = HttpUtil.post(uri, createProjectPayload, 300);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    public void requestProjectBind(String name, String path, String language, String projectType) throws JSONException, IOException {
        String endpoint = "api/v1/projects/bind";
        URI uri = this.baseUrl.resolve(endpoint);
        JSONObject payload = new JSONObject();
        payload.put("name", (Object)name);
        payload.put("path", (Object)CoreUtil.getContainerPath(path));
        payload.put("language", (Object)language);
        if (projectType == null) {
            projectType = ProjectType.getTypeFromLanguage(language).getId();
        }
        if (projectType != null) {
            payload.put("projectType", (Object)projectType);
        }
        payload.put("autoBuild", true);
        HttpUtil.HttpResult result = HttpUtil.post(uri, payload, 300);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    public void requestProjectUnbind(String projectID) throws IOException {
        String endpoint = "api/v1/projects/" + projectID + "/" + "unbind";
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    private void checkResult(HttpUtil.HttpResult result, URI uri, boolean checkContent) throws IOException {
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response code %d for uri %s with error message %s", result.responseCode, uri, result.error);
            throw new IOException(msg);
        }
        if (checkContent && result.response == null) {
            throw new IOException("Server returned good response code, but the content of the result is null for uri: " + uri);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConnectionError() {
        Logger.log("Connection to " + this.baseUrl + " lost");
        this.isConnected = false;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.clear();
        }
        CoreUtil.updateAll();
    }

    public synchronized void clearConnectionError() {
        Logger.log("Connection to " + this.baseUrl + " restored");
        try {
            String version;
            JSONObject envData = CodewindConnection.getEnvData(this.baseUrl);
            this.versionStr = version = CodewindConnection.getCodewindVersion(envData);
            Path path = CodewindConnection.getWorkspacePath(envData);
            if (path == null) {
                Logger.logError("Failed to get the local workspace path after reconnect");
                this.connectionErrorMsg = Messages.Connection_ErrConnection_WorkspaceErr;
                CoreUtil.updateAll();
                return;
            }
            this.localWorkspacePath = path;
            String socketNS = CodewindConnection.getSocketNamespace(envData);
            if (socketNS != null && !socketNS.equals(this.socketNamespace) || this.socketNamespace != null && !this.socketNamespace.equals(socketNS)) {
                this.socketNamespace = socketNS;
                this.socket.close();
                this.socket = new CodewindSocket(this);
                if (!this.socket.blockUntilFirstConnection()) {
                    Logger.logError("Failed to create a new socket with updated URI: " + this.socket.socketUri);
                    this.connectionErrorMsg = null;
                    CoreUtil.updateAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.logError("An exception occurred while trying to update the connection information", e);
            this.connectionErrorMsg = Messages.Connection_ErrConnection_UpdateCacheException;
            CoreUtil.updateAll();
            return;
        }
        this.connectionErrorMsg = null;
        this.isConnected = true;
        this.refreshApps(null);
        CoreUtil.updateAll();
    }

    public String toString() {
        return String.format("%s @ baseUrl=%s workspacePath=%s numApps=%d", CodewindConnection.class.getSimpleName(), this.baseUrl, this.localWorkspacePath, this.appMap.size());
    }

    public String toPrefsString() {
        return this.baseUrl.toString();
    }

    public void requestProjectCreate(ProjectType type, String name) throws JSONException, IOException {
        if (type == ProjectType.TYPE_LIBERTY) {
            this.requestMicroprofileProjectCreate(name);
        } else if (type == ProjectType.TYPE_SPRING) {
            this.requestSpringProjectCreate(name);
        } else if (type == ProjectType.TYPE_NODEJS) {
            this.requestNodeProjectCreate(name);
        } else {
            Logger.log("Creation of projects with type " + (Object)((Object)type) + " is not supported.");
        }
    }

    public void requestMicroprofileProjectCreate(String name) throws JSONException, IOException {
        String createEndpoint = "api/v1/projects";
        URI url = this.baseUrl.resolve(createEndpoint);
        JSONObject createProjectPayload = new JSONObject();
        createProjectPayload.put("name", (Object)name);
        createProjectPayload.put("language", (Object)"java");
        createProjectPayload.put("framework", (Object)"microprofile");
        HttpUtil.post(url, createProjectPayload);
    }

    public void requestSpringProjectCreate(String name) throws JSONException, IOException {
        String createEndpoint = "api/v1/projects";
        URI url = this.baseUrl.resolve(createEndpoint);
        JSONObject createProjectPayload = new JSONObject();
        createProjectPayload.put("name", (Object)name);
        createProjectPayload.put("language", (Object)"java");
        createProjectPayload.put("framework", (Object)"spring");
        HttpUtil.post(url, createProjectPayload);
    }

    public void requestNodeProjectCreate(String name) throws JSONException, IOException {
        String createEndpoint = "api/v1/projects";
        URI uri = this.baseUrl.resolve(createEndpoint);
        JSONObject createProjectPayload = new JSONObject();
        createProjectPayload.put("name", (Object)name);
        createProjectPayload.put("language", (Object)"nodejs");
        HttpUtil.HttpResult result = HttpUtil.post(uri, createProjectPayload);
        this.checkResult(result, uri, false);
    }

    public void requestProjectDelete(String projectId) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + projectId;
        URI uri = this.baseUrl.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri);
        this.checkResult(result, uri, false);
    }

    public IPath getWorkspacePath() {
        return this.localWorkspacePath;
    }

    public URI getNewProjectURI() {
        return this.getProjectURI("new-project");
    }

    public URI getImportProjectURI() {
        return this.getProjectURI("import-project");
    }

    private URI getProjectURI(String projectQuery) {
        try {
            URI uri = this.baseUrl;
            String query = projectQuery + "=" + "true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri;
        }
        catch (Exception e) {
            Logger.logError("Failed to get the project URI for the query: " + projectQuery, e);
            return null;
        }
    }

    public URL getAppMonitorURL(CodewindApplication app) {
        return this.getAppViewURL(app, "monitor");
    }

    public URL getAppViewURL(CodewindApplication app, String view) {
        try {
            URI uri = this.baseUrl;
            String query = "project=" + app.projectID;
            query = query + "&" + "view" + "=" + view;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the URL for the " + view + " view and the " + app.name + "application.", e);
            return null;
        }
    }

    public URL getPerformanceMonitorURL(CodewindApplication app) {
        try {
            URI uri = this.baseUrl;
            uri = uri.resolve("performance/charts");
            String query = "project=" + app.projectID;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the performance monitor URL for the " + app.name + "application.", e);
            return null;
        }
    }
}

