/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindReconnectJob;

public class CodewindConnectionManager {
    private static CodewindConnectionManager instance;
    public static final String CONNECTION_LIST_PREFSKEY = "mcc-connections";
    private List<CodewindConnection> connections = new ArrayList<CodewindConnection>();
    private List<String> brokenConnections = new ArrayList<String>();

    private CodewindConnectionManager() {
        instance = this;
    }

    private static CodewindConnectionManager instance() {
        if (instance == null) {
            instance = new CodewindConnectionManager();
        }
        return instance;
    }

    public static synchronized void add(CodewindConnection connection) {
        if (connection == null) {
            Logger.logError("Null connection passed to be added");
            return;
        }
        CodewindConnectionManager.instance().connections.add(connection);
        Logger.log("Added a new connection: " + connection.baseUrl);
    }

    public static synchronized List<CodewindConnection> activeConnections() {
        return Collections.unmodifiableList(CodewindConnectionManager.instance().connections);
    }

    public static synchronized CodewindConnection getActiveConnection(String baseUrl) {
        for (CodewindConnection mcc : CodewindConnectionManager.activeConnections()) {
            if (!mcc.baseUrl.toString().equals(baseUrl)) continue;
            return mcc;
        }
        return null;
    }

    public static synchronized int activeConnectionsCount() {
        return CodewindConnectionManager.instance().connections.size();
    }

    static synchronized boolean remove(String baseUrl) {
        boolean removeResult = false;
        CodewindConnection connection = CodewindConnectionManager.getActiveConnection(baseUrl.toString());
        if (connection != null) {
            connection.close();
            removeResult = CodewindConnectionManager.instance().connections.remove(connection);
        } else {
            removeResult = CodewindConnectionManager.instance().brokenConnections.remove(baseUrl);
        }
        if (!removeResult) {
            Logger.logError("Tried to remove connection " + baseUrl + ", but it didn't exist");
        }
        CoreUtil.updateAll();
        return removeResult;
    }

    public static synchronized void clear() {
        Logger.log("Clearing " + CodewindConnectionManager.instance().connections.size() + " connections");
        Iterator<CodewindConnection> it = CodewindConnectionManager.instance().connections.iterator();
        while (it.hasNext()) {
            CodewindConnection connection = it.next();
            connection.close();
            it.remove();
        }
    }

    public static synchronized List<String> brokenConnections() {
        return Collections.unmodifiableList(CodewindConnectionManager.instance().brokenConnections);
    }

    public static synchronized String getBrokenConnection(String url) {
        for (String brokenConnectionUrl : CodewindConnectionManager.brokenConnections()) {
            if (!brokenConnectionUrl.toString().equals(url)) continue;
            return brokenConnectionUrl;
        }
        return null;
    }

    private void writeToPreferences() {
        StringBuilder prefsBuilder = new StringBuilder();
        for (CodewindConnection codewindConnection : CodewindConnectionManager.activeConnections()) {
            prefsBuilder.append(codewindConnection.toPrefsString()).append('\n');
        }
        for (String string : CodewindConnectionManager.brokenConnections()) {
            prefsBuilder.append(string).append('\n');
        }
        Logger.log("Writing connections to preferences: " + prefsBuilder.toString());
        CodewindCorePlugin.getDefault().getPreferenceStore().setValue(CONNECTION_LIST_PREFSKEY, prefsBuilder.toString());
    }

    private void loadFromPreferences() {
        CodewindConnectionManager.clear();
        String storedConnections = CodewindCorePlugin.getDefault().getPreferenceStore().getString(CONNECTION_LIST_PREFSKEY).trim();
        Logger.log("Reading connections from preferences: \"" + storedConnections + "\"");
        for (String line : storedConnections.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            try {
                URI uri = new URI(line);
                CodewindConnection connection = CodewindObjectFactory.createCodewindConnection(uri);
                CodewindConnectionManager.add(connection);
            }
            catch (CodewindConnectionException mce) {
                this.brokenConnections.add(mce.connectionUrl.toString());
                CodewindReconnectJob.createAndStart(mce.connectionUrl);
            }
            catch (Exception e) {
                Logger.logError("Error loading connection from preferences", e);
            }
        }
    }

    public static boolean removeConnection(String connectionUrl) {
        CodewindConnectionManager.remove(connectionUrl);
        return true;
    }
}

