/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.core.internal.messages.Messages;

public enum AppState {
    STARTED("started", Messages.AppStateStarted),
    STARTING("starting", Messages.AppStateStarting),
    STOPPING("stopping", Messages.AppStateStopping),
    STOPPED("stopped", Messages.AppStateStopped),
    UNKNOWN("unknown", Messages.AppStateUnknown);

    public final String appState;
    public final String displayString;

    private AppState(String appState, String displayString) {
        this.appState = appState;
        this.displayString = displayString;
    }

    public static AppState get(String appState) {
        for (AppState state : AppState.values()) {
            if (!state.appState.equals(appState)) continue;
            return state;
        }
        Logger.logError("Unrecognized application state: " + appState);
        return UNKNOWN;
    }

    public String getDisplayString(StartMode mode) {
        if (this == STARTED && StartMode.DEBUG_MODES.contains((Object)mode)) {
            return Messages.AppStateDebugging;
        }
        return this.displayString;
    }
}

