/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

public enum ProjectLanguage {
    LANGUAGE_JAVA("java", "Java"),
    LANGUAGE_NODEJS("nodejs", "Node.js"),
    LANGUAGE_SWIFT("swift", "Swift"),
    LANGUAGE_PYTHON("python", "Python"),
    LANGUAGE_GO("go", "Go"),
    LANGUAGE_UNKNOWN("unknown", "Unknown");

    private final String id;
    private final String displayName;

    private ProjectLanguage(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ProjectLanguage getLanguage(String name) {
        for (ProjectLanguage language : ProjectLanguage.values()) {
            if (!language.id.equals(name)) continue;
            return language;
        }
        return LANGUAGE_UNKNOWN;
    }

    public String getMetricsRoot() {
        switch (this) {
            case LANGUAGE_NODEJS: {
                return "appmetrics-dash";
            }
            case LANGUAGE_SWIFT: {
                return "swiftmetrics-dash";
            }
            case LANGUAGE_JAVA: {
                return "javametrics-dash";
            }
        }
        return null;
    }
}

