/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

import org.eclipse.codewind.core.internal.constants.ProjectLanguage;

public enum ProjectType {
    TYPE_LIBERTY("liberty", "MicroProfile / Java EE"),
    TYPE_SPRING("spring", "Spring"),
    TYPE_SWIFT("swift", "Swift"),
    TYPE_NODEJS("nodejs", "Node.js"),
    TYPE_DOCKER("docker", "Other (Basic Container)"),
    TYPE_UNKNOWN("unknown", "Unknown");

    private final String id;
    private final String displayName;

    private ProjectType(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ProjectType getType(String name) {
        for (ProjectType type : ProjectType.values()) {
            if (!type.id.equals(name)) continue;
            return type;
        }
        return TYPE_UNKNOWN;
    }

    public static ProjectType getTypeFromLanguage(String language) {
        ProjectLanguage lang = ProjectLanguage.getLanguage(language);
        switch (lang) {
            case LANGUAGE_NODEJS: {
                return TYPE_NODEJS;
            }
            case LANGUAGE_SWIFT: {
                return TYPE_SWIFT;
            }
            case LANGUAGE_PYTHON: {
                return TYPE_DOCKER;
            }
            case LANGUAGE_GO: {
                return TYPE_DOCKER;
            }
        }
        return null;
    }
}

