/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.codewind.openapi.ui.commands.AbstractOpenApiGeneratorCommand;
import org.eclipse.codewind.openapi.ui.wizard.AbstractGenerateWizardPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractGenerateWizard
extends Wizard
implements INewWizard {
    protected AbstractGenerateWizardPage page;
    protected ISelection selection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    protected abstract AbstractOpenApiGeneratorCommand getCommand();

    public void addPage(IWizardPage p) {
        this.page = (AbstractGenerateWizardPage)p;
        super.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        boolean openConfirm;
        IResource ignoreFile;
        AbstractOpenApiGeneratorCommand cmd = this.getCommand();
        IProject project = this.page.getProject();
        if (this.page.getOutputFolder().equals(project.getFullPath().toString())) {
            ignoreFile = project.findMember(".openapi-generator-ignore");
        } else {
            IFolder outputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.page.getOutputFolder()));
            ignoreFile = outputFolder.findMember(".openapi-generator-ignore");
        }
        if (ignoreFile != null && ignoreFile.exists() && !(openConfirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.INFO_FILES_EXIST_TITLE, (String)Messages.INFO_FILES_EXIST_DESCRIPTION))) {
            return false;
        }
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)cmd);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            realException.printStackTrace();
            return false;
        }
        return true;
    }
}

