/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.codewind.openapi.ui.Constants;
import org.eclipse.codewind.openapi.ui.commands.AbstractOpenApiGeneratorCommand;
import org.eclipse.codewind.openapi.ui.commands.GenerateHtmlCommand;
import org.eclipse.codewind.openapi.ui.wizard.AbstractGenerateWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class GenerateHtmlWizard
extends AbstractGenerateWizard {
    private GenerateHtmlCommand cmd;

    public GenerateHtmlWizard() {
        this.setNeedsProgressMonitor(true);
    }

    @Override
    protected AbstractOpenApiGeneratorCommand getCommand() {
        this.cmd = new GenerateHtmlCommand();
        IProject project = this.page.getProject();
        this.cmd.setProject(project);
        this.cmd.setGeneratorType(null);
        this.cmd.setOpenApiFile(this.page.getSelectedOpenApiFile());
        this.cmd.setOutputFolderString(this.page.getOutputFolder());
        return this.cmd;
    }

    @Override
    public boolean performFinish() {
        boolean rc = super.performFinish();
        if (rc) {
            this.openInEditor();
        }
        return rc;
    }

    private void openInEditor() {
        String outputFolderString = this.cmd.getOutputFolderString();
        IResource htmlFile = ResourcesPlugin.getWorkspace().getRoot().findMember(outputFolderString + "/" + Constants.HTML_DOCUMENTATION_FILE);
        if (htmlFile != null && htmlFile instanceof IFile && htmlFile.exists()) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput((IFile)htmlFile), "org.eclipse.ui.browser.editor");
            }
            catch (PartInitException e) {
                Activator.log((int)1, (Exception)((Object)e));
            }
        }
    }
}

