/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import org.eclipse.codewind.openapi.core.util.Util;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractGenerateWizardPage
extends WizardPage {
    protected Text projectText;
    protected Text fileText;
    protected Text outputFolder;
    protected ISelection selection;
    protected IProject project;
    protected IFile preselectedOpenApiFile;
    protected Combo generatorTypes;
    protected Combo languages;
    protected boolean isCodewindProject = false;
    protected String codewindProjectLanguage = "";

    public AbstractGenerateWizardPage(String pageName) {
        super(pageName);
    }

    public AbstractGenerateWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public String getContainerName() {
        return this.projectText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public IProject getProject() {
        return this.project;
    }

    public String getGeneratorType() {
        return this.generatorTypes.getText();
    }

    public IFile getSelectedOpenApiFile() {
        return this.preselectedOpenApiFile;
    }

    public String getOutputFolder() {
        if (this.outputFolder.getText().equals(".")) {
            return this.project.getFullPath().toString();
        }
        return this.outputFolder.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        Label label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_PROJECT);
        this.projectText = new Text(container, 2060);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setEnabled(false);
        this.projectText.addModifyListener(e -> this.dialogChanged(e));
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_SPECIFICATION);
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(e -> this.dialogChanged(e));
        gd = new GridData(768);
        Button button = new Button(container, 8);
        button.setText(Messages.WIZARD_PAGE_BROWSE_FILE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractGenerateWizardPage.this.handleFileBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_OUTPUT_FOLDER);
        label.setToolTipText(Messages.WIZARD_PAGE_OUTPUT_FOLDER_TOOLTIP);
        this.outputFolder = new Text(container, 2052);
        gd = new GridData(768);
        this.outputFolder.setLayoutData((Object)gd);
        this.outputFolder.setToolTipText(Messages.WIZARD_PAGE_OUTPUT_FOLDER_TOOLTIP);
        this.outputFolder.addModifyListener(e -> this.dialogChanged(e));
        Button outputFolderBrowse = new Button(container, 8);
        outputFolderBrowse.setText(Messages.WIZARD_PAGE_BROWSE_FOLDER);
        outputFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractGenerateWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_LANGUAGE);
        this.languages = new Combo(container, 72);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.languages.setLayoutData((Object)gd);
        this.languages.addModifyListener(e -> this.dialogChanged(e));
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_GENERATOR_TYPE);
        label.setToolTipText(Messages.WIZARD_PAGE_GENERATOR_TYPE_TOOLTIP);
        this.generatorTypes = new Combo(container, 72);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.generatorTypes.setToolTipText(Messages.WIZARD_PAGE_GENERATOR_TYPE_TOOLTIP);
        this.generatorTypes.setLayoutData((Object)gd);
        this.generatorTypes.addModifyListener(e -> this.dialogChanged(e));
        this.initialize();
        this.dialogChanged(null);
        this.setControl((Control)container);
    }

    protected abstract void populateGeneratorTypesCombo(String var1);

    protected abstract void fillLanguagesCombo();

    protected void initialize() {
        this.fileText.setText("");
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IFile) {
                this.preselectedOpenApiFile = (IFile)obj;
                this.project = this.preselectedOpenApiFile.getProject();
                this.fileText.setText(this.preselectedOpenApiFile.getFullPath().toString());
            } else if (obj instanceof IContainer) {
                IContainer container = (IContainer)obj;
                this.project = container.getProject();
            } else {
                String possibleLanguage = Util.getProjectLanguage((Object)obj);
                if (possibleLanguage.length() > 0) {
                    this.codewindProjectLanguage = possibleLanguage;
                }
                this.project = Util.getProject((Object)obj);
            }
            if (this.project != null) {
                boolean foundInitialSpec = this.findSpecificationAtRoot("openapi.yaml");
                if (!foundInitialSpec && !(foundInitialSpec = this.findSpecificationAtRoot("openapi.yml"))) {
                    foundInitialSpec = this.findSpecificationAtRoot("openapi.json");
                }
                this.projectText.setText(this.project.getName());
            }
        }
        if (this.project != null) {
            this.isCodewindProject = Util.isCodewindProject((IProject)this.project);
            if (this.isCodewindProject) {
                if (this.codewindProjectLanguage.length() == 0) {
                    this.codewindProjectLanguage = Util.getProjectLanguage((IProject)this.project);
                }
                if (this.codewindProjectLanguage.length() > 0) {
                    switch (this.codewindProjectLanguage) {
                        case "go": 
                        case "Go": {
                            this.codewindProjectLanguage = "Go";
                            this.populateGeneratorTypesCombo("Go");
                            break;
                        }
                        case "java": 
                        case "Java": {
                            this.codewindProjectLanguage = "Java";
                            this.populateGeneratorTypesCombo("Java");
                            break;
                        }
                        case "nodejs": 
                        case "Node.js": {
                            this.codewindProjectLanguage = "Node.js";
                            this.populateGeneratorTypesCombo("Node.js");
                            break;
                        }
                        case "swift": 
                        case "Swift": {
                            this.codewindProjectLanguage = "Swift";
                            this.populateGeneratorTypesCombo("Swift");
                            break;
                        }
                        case "python": 
                        case "Python": {
                            this.codewindProjectLanguage = "Python";
                            this.populateGeneratorTypesCombo("Python");
                            break;
                        }
                    }
                    this.languages.add(this.codewindProjectLanguage);
                    this.languages.setText(this.codewindProjectLanguage);
                    this.languages.select(0);
                } else {
                    this.fillLanguagesCombo();
                }
            } else {
                this.fillLanguagesCombo();
            }
            if ("swift".equals(this.codewindProjectLanguage) || "Swift".equals(this.codewindProjectLanguage)) {
                this.outputFolder.setText(this.project.getFullPath().toString() + "/Sources");
            } else {
                this.outputFolder.setText(this.project.getFullPath().toString());
            }
        }
    }

    protected void dialogChanged(ModifyEvent e) {
        if (e != null && e.getSource() == this.languages) {
            this.languages.getText();
            this.populateGeneratorTypesCombo(this.languages.getText());
        }
        this.updateStatus(null);
        this.setPageComplete(true);
        IProject container = this.project;
        String fileName = this.getFileName();
        if (this.projectText.getText().length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_PROVIDED);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_IMPORTED);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_ACCESSIBLE);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_SELECT_SPEC);
            return;
        }
        if (this.outputFolder.getText().length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_SELECT_OUTPUT_FOLDER);
            return;
        }
        if (this.languages.getText().length() == 0 && this.languages.getSelectionIndex() < 0) {
            this.addInfoStatus(Messages.WIZARD_PAGE_SELECT_LANGUAGE);
            return;
        }
        if (this.generatorTypes.getText().length() == 0 && this.generatorTypes.getSelectionIndex() < 0) {
            this.addInfoStatus(Messages.WIZARD_PAGE_SELECT_GENERATOR_TYPE);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void addInfoStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(false);
    }

    protected void handleFileBrowse() {
        Object[] result;
        ElementTreeSelectionDialog ed = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        ed.setInput((Object)this.project);
        ed.setAllowMultiple(false);
        ed.setMessage(Messages.BROWSE_DIALOG_MESSAGE_SELECT_SPEC);
        ed.addFilter(new ViewerFilter(){

            public boolean select(Viewer arg0, Object arg1, Object resource) {
                if (resource instanceof IFile) {
                    IFile f = (IFile)resource;
                    String fileName = f.getName();
                    return fileName.toLowerCase().contains("openapi") && (fileName.endsWith(".yaml") || fileName.endsWith(".yml") || fileName.endsWith(".json"));
                }
                return true;
            }
        });
        ed.setTitle(Messages.BROWSE_DIALOG_TITLE_SELECT_SPEC);
        if (ed.open() == 0 && (result = ed.getResult()).length == 1) {
            this.fileText.setText(((IFile)result[0]).getFullPath().toString());
        }
    }

    protected void handleBrowse() {
        ElementTreeSelectionDialog ed = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        ed.setInput((Object)this.project);
        ed.setAllowMultiple(false);
        ed.setMessage(Messages.BROWSE_DIALOG_MESSAGE_SELECT_FOLDER);
        ed.setTitle(Messages.BROWSE_DIALOG_TITLE_SELECT_FOLDER);
        String out = this.outputFolder.getText();
        if (out.startsWith(this.project.getFullPath().toString())) {
            String s = this.outputFolder.getText().substring(this.project.getFullPath().toString().length());
            ed.setInitialSelection((Object)this.project.findMember(s));
        }
        ed.addFilter(new ViewerFilter(){

            public boolean select(Viewer arg0, Object arg1, Object resource) {
                return !(resource instanceof IFile);
            }
        });
        ed.setEmptyListMessage(Messages.BROWSE_DIALOG_NO_CHILD_FOLDERS);
        if (ed.open() == 0) {
            Object[] result = ed.getResult();
            if (result.length == 1) {
                this.outputFolder.setText(((IContainer)result[0]).getFullPath().toString());
            } else {
                this.outputFolder.setText(this.project.getFullPath().toString());
            }
        }
    }

    protected boolean findSpecificationAtRoot(String fileName) {
        IResource spec1 = this.project.findMember(fileName);
        if (spec1 != null && spec1.exists() && spec1 instanceof IFile && spec1.isAccessible()) {
            this.preselectedOpenApiFile = (IFile)spec1;
            this.fileText.setText(this.preselectedOpenApiFile.getFullPath().toString());
            return true;
        }
        return false;
    }

    public boolean doFinish(IProgressMonitor monitor) {
        return false;
    }
}

