/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import org.eclipse.codewind.openapi.core.util.Util;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.codewind.openapi.ui.wizard.AbstractGenerateWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GenerateHtmlWizardPage
extends AbstractGenerateWizardPage {
    private ISelection selection;

    public GenerateHtmlWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.HTML_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.HTML_WIZARD_PAGE_DESCRIPTION);
        this.selection = selection;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        Label label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_PROJECT);
        this.projectText = new Text(container, 2052);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.addModifyListener(e -> this.dialogChanged());
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_SPECIFICATION);
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(e -> this.dialogChanged());
        gd = new GridData(768);
        Button button = new Button(container, 8);
        button.setText(Messages.WIZARD_PAGE_BROWSE_FILE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateHtmlWizardPage.this.handleFileBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.WIZARD_PAGE_OUTPUT_FOLDER);
        label.setToolTipText(Messages.WIZARD_PAGE_OUTPUT_FOLDER_TOOLTIP);
        this.outputFolder = new Text(container, 2052);
        gd = new GridData(768);
        this.outputFolder.setLayoutData((Object)gd);
        this.outputFolder.setToolTipText(Messages.WIZARD_PAGE_OUTPUT_FOLDER_TOOLTIP);
        this.outputFolder.addModifyListener(e -> this.dialogChanged());
        Button outputFolderBrowse = new Button(container, 8);
        outputFolderBrowse.setText(Messages.WIZARD_PAGE_BROWSE_FOLDER);
        outputFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateHtmlWizardPage.this.handleBrowse();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    @Override
    protected void initialize() {
        this.fileText.setText("");
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IFile) {
                this.preselectedOpenApiFile = (IFile)obj;
                this.project = this.preselectedOpenApiFile.getProject();
                this.fileText.setText(this.preselectedOpenApiFile.getFullPath().toString());
            } else if (obj instanceof IContainer) {
                IContainer container = (IContainer)obj;
                this.project = container.getProject();
            } else {
                this.project = Util.getProject((Object)obj);
            }
            if (this.project != null) {
                boolean foundInitialSpecification = this.findSpecificationAtRoot("openapi.yaml");
                if (!foundInitialSpecification && !(foundInitialSpecification = this.findSpecificationAtRoot("openapi.yml"))) {
                    foundInitialSpecification = this.findSpecificationAtRoot("openapi.json");
                }
                this.projectText.setText(this.project.getName());
                this.outputFolder.setText(this.project.getFullPath().toString());
            }
        }
    }

    protected void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_PROVIDED);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_IMPORTED);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.WIZARD_PAGE_PROJECT_NOT_ACCESSIBLE);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_SELECT_SPEC);
            return;
        }
        if (this.outputFolder.getText().length() == 0) {
            this.updateStatus(Messages.WIZARD_PAGE_SELECT_OUTPUT_FOLDER);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    @Override
    protected void populateGeneratorTypesCombo(String language) {
    }

    @Override
    protected void fillLanguagesCombo() {
    }
}

