/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;

public class CodewindManager {
    public static final String DEFAULT_CONNECTION_URI = "http://localhost:9090/";
    private static CodewindManager codewindManager;
    CodewindConnection localConnection = null;
    URI localURI = null;
    InstallUtil.InstallStatus installStatus = null;
    InstallerStatus installerStatus = null;

    private CodewindManager() {
        if (this.getInstallStatus(true) == InstallUtil.InstallStatus.RUNNING) {
            this.createLocalConnection();
            if (this.localConnection != null) {
                this.localConnection.refreshApps(null);
            }
        }
    }

    public static CodewindManager getManager() {
        if (codewindManager == null) {
            codewindManager = new CodewindManager();
        }
        return codewindManager;
    }

    public InstallUtil.InstallStatus getInstallStatus(boolean update) {
        if (this.installStatus != null && !update) {
            return this.installStatus;
        }
        try {
            this.installStatus = InstallUtil.getInstallStatus();
            if (this.installStatus != InstallUtil.InstallStatus.RUNNING) {
                this.removeLocalConnection();
            }
            return this.installStatus;
        }
        catch (IOException e) {
            Logger.logError("An error occurred trying to get the installer status", e);
        }
        catch (TimeoutException e) {
            Logger.logError("Timed out trying to get the installer status", e);
        }
        return InstallUtil.InstallStatus.UNKNOWN;
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateAll();
    }

    public URI getLocalURI() {
        if (this.localURI == null) {
            try {
                this.localURI = new URI(DEFAULT_CONNECTION_URI);
            }
            catch (URISyntaxException e) {
                Logger.logError("Failed to create a URI from the string: http://localhost:9090/", e);
            }
        }
        return this.localURI;
    }

    public synchronized CodewindConnection getLocalConnection() {
        return this.localConnection;
    }

    public synchronized CodewindConnection createLocalConnection() {
        if (this.localConnection != null) {
            return this.localConnection;
        }
        try {
            CodewindConnection connection;
            this.localConnection = connection = CodewindObjectFactory.createCodewindConnection(this.getLocalURI());
            CodewindConnectionManager.add(connection);
            return connection;
        }
        catch (Exception e) {
            Logger.log("Attempting to connect to Codewind failed: " + e.getMessage());
            return null;
        }
    }

    public synchronized void removeLocalConnection() {
        if (this.localConnection != null) {
            this.localConnection.close();
            CodewindConnectionManager.removeConnection(this.localConnection.baseUrl.toString());
            this.localConnection = null;
        }
    }

    public void refresh() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            conn.refreshApps(null);
        }
    }

    public boolean hasActiveApplications() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            for (CodewindApplication app : conn.getApps()) {
                if (!app.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

