/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public class InstallUtil {
    public static final String STOP_APP_CONTAINERS_PREFSKEY = "stopAppContainers";
    public static final String STOP_APP_CONTAINERS_ALWAYS = "stopAppContainersAlways";
    public static final String STOP_APP_CONTAINERS_NEVER = "stopAppContainersNever";
    public static final String STOP_APP_CONTAINERS_PROMPT = "stopAppContainersPrompt";
    public static final String STOP_APP_CONTAINERS_DEFAULT = "stopAppContainersPrompt";
    private static final Map<PlatformUtil.OperatingSystem, String> installMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final String INSTALLER_DIR = "installerWorkDir";
    private static final String INSTALL_DEV_CMD = "install-dev";
    private static final String INSTALL_CMD = "install";
    private static final String START_CMD = "start";
    private static final String STOP_CMD = "stop";
    private static final String STOP_ALL_CMD = "stop-all";
    private static final String STATUS_CMD = "status";
    private static final String REMOVE_CMD = "remove";
    private static final String INSTALL_DEV_VAR = "INSTALL_DEV";
    private static final String TAG_OPTION = "-t";
    private static final String DEFAULT_INSTALL_VERSION = "0.2";
    private static final String INSTALL_VERSION_VAR = "INSTALL_VERSION";
    private static String installCmd;
    private static String installVersion;
    private static String installExec;

    public static InstallStatus getInstallStatus() throws IOException, TimeoutException {
        ProcessHelper.ProcessResult result = InstallUtil.statusCodewind();
        return InstallStatus.getStatus(result.getExitValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult startCodewind(IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StartCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STARTING);
            process = InstallUtil.runInstaller(START_CMD, InstallUtil.getVersion());
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(90));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult stopCodewind(boolean stopAll, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StopCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STOPPING);
            process = InstallUtil.runInstaller(stopAll ? STOP_ALL_CMD : STOP_CMD, null);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult installCodewind(IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.INSTALLING);
            process = InstallUtil.runInstaller(InstallUtil.getInstallCmd(), InstallUtil.getVersion());
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 1000, 300, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult removeCodewind(IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RemovingCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.UNINSTALLING);
            process = InstallUtil.runInstaller(REMOVE_CMD, null);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    public static ProcessHelper.ProcessResult statusCodewind() throws IOException, TimeoutException {
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            process = InstallUtil.runInstaller(STATUS_CMD, null);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)new NullProgressMonitor());
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static Process runInstaller(String cmd, String version) throws IOException {
        String installerPath = InstallUtil.getInstallerExecutable();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(installerPath);
        cmdList.add(cmd);
        if (version != null) {
            cmdList.add(TAG_OPTION);
            cmdList.add(version);
        }
        String[] command = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin:" + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        return builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstallerExecutable() throws IOException {
        if (installExec != null && new File(installExec).exists()) {
            return installExec;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        String relPath = installMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable";
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String installerDir = InstallUtil.getInstallerDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)CodewindCorePlugin.getDefault().getBundle(), (IPath)new Path(relPath), (boolean)false);
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = installExec = execPath;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getInstallerDir() {
        IPath stateLoc = CodewindCorePlugin.getDefault().getStateLocation();
        return stateLoc.append(INSTALLER_DIR).toOSString();
    }

    private static String getInstallCmd() {
        if (installCmd == null) {
            String value = System.getenv(INSTALL_DEV_VAR);
            installCmd = "true".equals(value) ? INSTALL_DEV_CMD : INSTALL_CMD;
        }
        return installCmd;
    }

    private static String getVersion() {
        if (INSTALL_DEV_CMD.equals(InstallUtil.getInstallCmd())) {
            return null;
        }
        if (installVersion == null) {
            String value = System.getenv(INSTALL_VERSION_VAR);
            installVersion = value != null && !value.isEmpty() ? value : DEFAULT_INSTALL_VERSION;
        }
        return installVersion;
    }

    static {
        installMap.put(PlatformUtil.OperatingSystem.LINUX, "resources/codewind-installer-linux");
        installMap.put(PlatformUtil.OperatingSystem.MAC, "resources/codewind-installer-macos");
        installMap.put(PlatformUtil.OperatingSystem.WINDOWS, "resources/codewind-installer-win.exe");
        installCmd = null;
        installVersion = null;
        installExec = null;
    }

    public static enum InstallStatus {
        RUNNING(2),
        INSTALLED(1),
        NOT_INSTALLED(0),
        UNKNOWN(-1);

        private int code;

        private InstallStatus(int code) {
            this.code = code;
        }

        public static InstallStatus getStatus(int code) {
            for (InstallStatus status : InstallStatus.values()) {
                if (status.code != code) continue;
                return status;
            }
            Logger.logError("Unrecognized installer status code: " + code);
            return UNKNOWN;
        }

        public boolean isInstalled() {
            return this != NOT_INSTALLED && this != UNKNOWN;
        }
    }
}

