/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

public class FilewatcherUtils {
    public static void sleepIgnoreInterrupt(long sleepTimeInMsecs) {
        try {
            Thread.sleep(sleepTimeInMsecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep(long sleepTimeInMsecs) {
        try {
            Thread.sleep(sleepTimeInMsecs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripTrailingSlash(String str) {
        while (str.trim().endsWith("/")) {
            str = str.trim();
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
    }

    public static ExponentialBackoffUtil getDefaultBackoffUtil(long maxFailureDelay) {
        return new ExponentialBackoffUtil(500L, maxFailureDelay, 1.5f);
    }

    public static class ExponentialBackoffUtil {
        private final long minFailureDelay;
        private long failureDelay;
        private final long maxFailureDelay;
        private final float backoffExponent;

        public ExponentialBackoffUtil(long minFailureDelay, long maxFailureDelay, float backoffExponent) {
            this.minFailureDelay = minFailureDelay;
            this.maxFailureDelay = maxFailureDelay;
            this.failureDelay = minFailureDelay;
            this.backoffExponent = backoffExponent;
        }

        public void sleep() throws InterruptedException {
            Thread.sleep(this.failureDelay);
        }

        public void sleepIgnoreInterrupt() {
            FilewatcherUtils.sleepIgnoreInterrupt(this.failureDelay);
        }

        public void failIncrease() {
            this.failureDelay = (long)((float)this.failureDelay * this.backoffExponent);
            if (this.failureDelay > this.maxFailureDelay) {
                this.failureDelay = this.maxFailureDelay;
            }
        }

        public void successReset() {
            this.failureDelay = this.minFailureDelay;
        }
    }
}

