/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.internal.TyrusClientEndpoint;
import org.glassfish.tyrus.client.ClientManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketManagerThread
extends Thread {
    private final TyrusClientEndpoint endpoint;
    private final String wsUrl;
    private final Filewatcher watcher;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private final FWLogger log = FWLogger.getInstance();
    private static final int SEND_KEEPALIVE_EVERY_X_SECONDS = 25;
    private Session mostRecentSessionFromEndpoint_synch_lock = null;
    private final Object lock = new Object();
    private final List<Long> establishConnectionRequests_synch = new ArrayList<Long>();

    public WebSocketManagerThread(String wsUrl, Filewatcher watcher) {
        this.setDaemon(true);
        this.setName(WebSocketManagerThread.class.getName());
        this.endpoint = new TyrusClientEndpoint(this, wsUrl);
        this.wsUrl = wsUrl;
        this.watcher = watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Long nextPingInNanos = null;
            this.log.logInfo("Web socket manager thread for '" + this.wsUrl + "' begun.");
            while (!this.disposed.get()) {
                try {
                    if (nextPingInNanos == null) {
                        nextPingInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(25L, TimeUnit.SECONDS);
                    }
                    boolean establishConnection = false;
                    List<Long> list = this.establishConnectionRequests_synch;
                    synchronized (list) {
                        if (this.establishConnectionRequests_synch.size() > 0) {
                            establishConnection = true;
                        } else {
                            this.establishConnectionRequests_synch.wait(100L);
                        }
                    }
                    if (establishConnection) {
                        this.establishOrReestablishConnection();
                        list = this.establishConnectionRequests_synch;
                        synchronized (list) {
                            this.establishConnectionRequests_synch.clear();
                        }
                        nextPingInNanos = null;
                        continue;
                    }
                    if (nextPingInNanos == null || System.nanoTime() <= nextPingInNanos) continue;
                    try {
                        Session currSession;
                        Object object = this.lock;
                        synchronized (object) {
                            currSession = this.mostRecentSessionFromEndpoint_synch_lock;
                        }
                        if (currSession != null) {
                            currSession.getBasicRemote().sendText("{}");
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    nextPingInNanos = null;
                }
                catch (Throwable t) {
                    this.log.logSevere("Unexpected exception occurred.", t, null);
                    FilewatcherUtils.sleepIgnoreInterrupt(1000L);
                }
            }
        }
        finally {
            this.log.logInfo("Web socket thread for '" + this.wsUrl + "' ended.");
        }
    }

    public void informConnectionFail() {
        if (this.disposed.get()) {
            return;
        }
        this.watcher.refreshWatchStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEstablishConnection() {
        if (this.disposed.get()) {
            return;
        }
        List<Long> list = this.establishConnectionRequests_synch;
        synchronized (list) {
            if (this.establishConnectionRequests_synch.size() == 0) {
                this.establishConnectionRequests_synch.add(System.nanoTime());
                this.establishConnectionRequests_synch.notify();
                this.log.logInfo("Establish connection queued for '" + this.wsUrl + "', and accepted.");
            } else {
                this.log.logInfo("Establish connection queued for '" + this.wsUrl + "', but ignored.");
            }
        }
    }

    public void dispose() {
        if (this.disposed.get()) {
            return;
        }
        this.disposed.set(true);
        this.log.logInfo("disposed() called in " + this.getClass().getSimpleName());
        FilewatcherUtils.newThread(() -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.mostRecentSessionFromEndpoint_synch_lock != null) {
                    try {
                        this.mostRecentSessionFromEndpoint_synch_lock.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void establishOrReestablishConnection() {
        boolean success = false;
        FilewatcherUtils.ExponentialBackoffUtil delay = FilewatcherUtils.getDefaultBackoffUtil(4000L);
        int attemptNumber = 1;
        while (!this.disposed.get() && !success) {
            block5: {
                try {
                    this.log.logInfo("Attempting to establish connection to web socket, attempt #" + attemptNumber);
                    ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
                    ClientManager client = ClientManager.createClient();
                    Session sess = client.connectToServer((Endpoint)this.endpoint, cec, new URI(this.wsUrl + "/websockets/file-changes/v1"));
                    boolean bl = success = sess != null && sess.isOpen();
                    if (success) {
                        this.log.logInfo("Established connection to web socket, after attempt #" + attemptNumber);
                        delay.successReset();
                        this.watcher.refreshWatchStatus();
                    } else {
                        this.log.logError("Unable to establish connection to web socket on attempt #" + attemptNumber);
                    }
                }
                catch (Throwable t) {
                    String msg = "Unable to connect to web socket: " + t.getClass().getSimpleName() + " (attempt #" + attemptNumber + "): " + t.getMessage();
                    this.log.logError(msg);
                    success = false;
                    if (t instanceof DeploymentException && t.getMessage().equals("Connection failed.")) break block5;
                    t.printStackTrace();
                }
            }
            if (success || this.disposed.get()) continue;
            delay.sleepIgnoreInterrupt();
            delay.failIncrease();
            ++attemptNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSessionFromEndpoint(Session s) {
        Object object = this.lock;
        synchronized (object) {
            this.mostRecentSessionFromEndpoint_synch_lock = s;
        }
    }

    void receiveMessage(String s) {
        if (this.disposed.get()) {
            return;
        }
        try {
            JSONObject jo = new JSONObject(s);
            String type = jo.getString("type");
            if (type.equals("debug")) {
                this.handleDebugMessage(jo);
                return;
            }
            this.log.logInfo("Received watch change message from WebSocket: " + s);
            JSONArray projects = jo.getJSONArray("projects");
            ArrayList<ProjectToWatch.ProjectToWatchFromWebSocket> ptwList = new ArrayList<ProjectToWatch.ProjectToWatchFromWebSocket>();
            for (int x = 0; x < projects.length(); ++x) {
                JSONObject projectToWatchJson = projects.getJSONObject(x);
                String changeType = projectToWatchJson.getString("changeType");
                ProjectToWatch.ProjectToWatchFromWebSocket ptw = new ProjectToWatch.ProjectToWatchFromWebSocket(projectToWatchJson, changeType);
                ptwList.add(ptw);
            }
            String projectList = ptwList.stream().map(e -> "[" + e.getProjectId() + " in " + e.getPathToMonitor() + "], ").reduce((a, b) -> a + b).get().trim();
            projectList = projectList.substring(0, projectList.length() - 1);
            this.log.logInfo("Watch list update received for { " + projectList + " }");
            this.watcher.internal_updateFileWatchStateFromWebSocket(ptwList);
        }
        catch (JSONException e2) {
            this.log.logSevere("Unexpected JSON exception when trying to parse message", e2, null);
        }
        catch (IOException e3) {
            this.log.logSevere("IOException from file watch state updater", e3, null);
        }
    }

    private void handleDebugMessage(JSONObject jsonObj) {
        try {
            String msg = jsonObj.getString("msg");
            this.log.logInfo("------------------------------------------------------------");
            this.log.logInfo("[Server-Debug] " + msg);
            this.log.logInfo("------------------------------------------------------------");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

