/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.ui.internal.actions.AttachDebuggerAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppMonitorAction;
import org.eclipse.codewind.ui.internal.actions.OpenPerfMonitorAction;
import org.eclipse.codewind.ui.internal.actions.UnbindProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class CodewindApplicationActionProvider
extends CommonActionProvider {
    private AttachDebuggerAction attachDebuggerAction;
    private OpenAppMonitorAction openAppMonitorAction;
    private OpenPerfMonitorAction openPerfMonitorAction;
    private UnbindProjectAction unbindProjectAction;
    private OpenAppDoubleClickAction openAppDoubleClickAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        StructuredViewer selProvider = aSite.getStructuredViewer();
        this.attachDebuggerAction = new AttachDebuggerAction((ISelectionProvider)selProvider);
        this.openAppMonitorAction = new OpenAppMonitorAction((ISelectionProvider)selProvider);
        this.openPerfMonitorAction = new OpenPerfMonitorAction((ISelectionProvider)selProvider);
        this.unbindProjectAction = new UnbindProjectAction((ISelectionProvider)selProvider);
        this.openAppDoubleClickAction = new OpenAppDoubleClickAction((ISelectionProvider)selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.attachDebuggerAction.showAction()) {
            menu.appendToGroup("group.generate", (IAction)this.attachDebuggerAction);
        }
        if (this.openAppMonitorAction.showAction()) {
            menu.appendToGroup("group.open", (IAction)this.openAppMonitorAction);
        }
        if (this.openPerfMonitorAction.showAction()) {
            menu.appendToGroup("group.open", (IAction)this.openPerfMonitorAction);
        }
        menu.appendToGroup("additions", (IAction)this.unbindProjectAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAppDoubleClickAction);
    }

    private static class OpenAppDoubleClickAction
    extends SelectionProviderAction {
        private final OpenAppAction actionDelegate = new OpenAppAction();

        public OpenAppDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            this.actionDelegate.selectionChanged((IAction)this, (ISelection)sel);
        }

        public void run() {
            this.actionDelegate.run((IAction)this);
        }
    }
}

