/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.WizardLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CodewindInstall {
    public static boolean isCodewindInstalled() throws InvocationTargetException {
        try {
            ProcessHelper.ProcessResult result = InstallUtil.statusCodewind();
            return result.getExitValue() != 0;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, "An error occurred trying to determine Codewind status: " + e.getMessage());
        }
        catch (TimeoutException e) {
            throw new InvocationTargetException(e, "Codewind did not return status in the expected time: " + e.getMessage());
        }
    }

    public static void codewindInstallerDialog() {
        Shell shell = Display.getDefault().getActiveShell();
        if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindDialogMessage)) {
            CodewindInstall.installCodewind(CodewindInstall.getNewProjectPrompt());
        }
    }

    public static void codewindInstallerDialog(IProject project) {
        Shell shell = Display.getDefault().getActiveShell();
        if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindDialogMessage)) {
            CodewindInstall.installCodewind(CodewindInstall.addExistingProjectPrompt(project));
        }
    }

    public static void installCodewind(final Runnable prompt) {
        try {
            Job job = new Job(Messages.InstallCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ProcessHelper.ProcessResult result = InstallUtil.installCodewind((IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            CodewindInstall.removeCodewind();
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, "There was a problem trying to install Codewind: ");
                        }
                        if (result.getExitValue() == 0) {
                            CodewindInstall.startCodewind(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus("An error occurred trying to install Codewind.", e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus("Codewind did not install in the expected time.", e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred installing Codewind: ", (Throwable)e);
        }
    }

    public static void startCodewind(final Runnable prompt) {
        try {
            Job job = new Job(Messages.StartingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ProcessHelper.ProcessResult result = InstallUtil.startCodewind((IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, "There was a problem trying to start Codewind: ");
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus("An error occurred trying to start Codewind.", e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus("Codewind did not start in the expected time.", e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred starting Codewind: ", (Throwable)e);
        }
    }

    public static void stopCodewind() {
        try {
            Job job = new Job(Messages.StoppingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean stopAll = CodewindInstall.getStopAll(monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProcessHelper.ProcessResult result = InstallUtil.stopCodewind((boolean)stopAll, (IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, "There was a problem trying to stop Codewind: ");
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus("An error occurred trying to stop Codewind.", e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus("Codewind did not stop in the expected time.", e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred stopping Codewind: ", (Throwable)e);
        }
    }

    public static Runnable getNewProjectPrompt() {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindNewProjectMessage)) {
                    NewCodewindProjectWizard wizard = new NewCodewindProjectWizard();
                    WizardLauncher.launchWizardWithoutSelection(wizard);
                }
            }
        };
    }

    public static Runnable addExistingProjectPrompt(final IProject project) {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)NLS.bind((String)Messages.InstallCodewindAddProjectMessage, (Object)project.getName()))) {
                    CodewindManager manager = CodewindManager.getManager();
                    CodewindConnection connection = manager.createLocalConnection();
                    if (connection != null && connection.isConnected()) {
                        BindProjectWizard wizard = new BindProjectWizard(connection, project);
                        WizardLauncher.launchWizardWithoutSelection(wizard);
                    } else {
                        Logger.logError((String)"In BindProjectAction run method and Codewind is not installed or has unknown status.");
                        return;
                    }
                }
            }
        };
    }

    public static void removeCodewind() {
        try {
            Job job = new Job(Messages.RemovingCodewindJobLabel){

                protected IStatus run(IProgressMonitor mon) {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                    try {
                        ProcessHelper.ProcessResult result;
                        InstallUtil.InstallStatus status = InstallUtil.getInstallStatus();
                        if (status == InstallUtil.InstallStatus.RUNNING) {
                            result = InstallUtil.stopCodewind((boolean)true, (IProgressMonitor)monitor.split(20));
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, "There was a problem trying to stop Codewind: ");
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.setWorkRemaining(80);
                        result = InstallUtil.removeCodewind((IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, "There was a problem trying to remove Codewind: ");
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus("An error occurred trying to remove Codewind.", e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus("Codewind did not remove in the expected time.", e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred removing Codewind images: ", (Throwable)e);
        }
    }

    private static IStatus getErrorStatus(ProcessHelper.ProcessResult result, String msg) {
        Logger.logError((String)("Installer failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
        return CodewindInstall.getErrorStatus(msg + errorText, null);
    }

    private static IStatus getErrorStatus(String msg, Throwable t) {
        Logger.logError((String)msg, (Throwable)t);
        ViewHelper.refreshCodewindExplorerView(null);
        return new Status(4, "org.eclipse.codewind.ui", msg, t);
    }

    private static boolean getStopAll(final IProgressMonitor monitor) {
        final IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        if ("stopAppContainersPrompt".contentEquals(prefs.getString("stopAppContainers"))) {
            if (!CodewindManager.getManager().hasActiveApplications()) {
                return false;
            }
            final boolean[] stopApps = new boolean[]{false};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle stopAppsQuestion = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.StopAllDialog_Title, (String)Messages.StopAllDialog_Message, (String)Messages.StopAllDialog_ToggleMessage, (boolean)false, null, null);
                    switch (stopAppsQuestion.getReturnCode()) {
                        case 2: {
                            stopApps[0] = true;
                            break;
                        }
                        case 1: {
                            monitor.setCanceled(true);
                            break;
                        }
                    }
                    if (!monitor.isCanceled() && stopAppsQuestion.getToggleState()) {
                        prefs.setValue("stopAppContainers", stopApps[0] ? "stopAppContainersAlways" : "stopAppContainersNever");
                    }
                }
            });
            return stopApps[0];
        }
        return "stopAppContainersAlways".contentEquals(prefs.getString("stopAppContainers"));
    }
}

