/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class InstallerAction
extends SelectionProviderAction {
    public final ActionType actionType;

    public InstallerAction(ActionType actionType, ISelectionProvider selectionProvider) {
        super(selectionProvider, actionType.disableLabel);
        this.actionType = actionType;
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindManager) {
            InstallUtil.InstallStatus status = CodewindManager.getManager().getInstallStatus(false);
            if (this.actionType == ActionType.INSTALL_UNINSTALL) {
                switch (status) {
                    case NOT_INSTALLED: {
                        this.setText(this.actionType.enableLabel);
                        this.setEnabled(true);
                        break;
                    }
                    case INSTALLED: 
                    case RUNNING: {
                        this.setText(this.actionType.disableLabel);
                        this.setEnabled(true);
                        break;
                    }
                    default: {
                        this.setText(this.actionType.enableLabel);
                        this.setEnabled(false);
                    }
                }
                return;
            }
            switch (status) {
                case NOT_INSTALLED: {
                    this.setText(this.actionType.enableLabel);
                    this.setEnabled(false);
                    break;
                }
                case INSTALLED: {
                    this.setText(this.actionType.enableLabel);
                    this.setEnabled(true);
                    break;
                }
                case RUNNING: {
                    this.setText(this.actionType.disableLabel);
                    this.setEnabled(true);
                    break;
                }
                default: {
                    this.setText(this.actionType.enableLabel);
                    this.setEnabled(false);
                }
            }
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.actionType == ActionType.INSTALL_UNINSTALL) {
            if (this.actionType.enableLabel.equals(this.getText())) {
                CodewindInstall.installCodewind(null);
            } else {
                CodewindInstall.removeCodewind();
            }
        } else if (this.actionType.enableLabel.equals(this.getText())) {
            CodewindInstall.startCodewind(null);
        } else {
            CodewindInstall.stopCodewind();
        }
    }

    public static enum ActionType {
        INSTALL_UNINSTALL(Messages.InstallerActionInstallLabel, Messages.InstallerActionUninstallLabel),
        START_STOP(Messages.InstallerActionStartLabel, Messages.InstallerActionStopLabel);

        public final String enableLabel;
        public final String disableLabel;

        private ActionType(String onLabel, String offLabel) {
            this.enableLabel = onLabel;
            this.disableLabel = offLabel;
        }
    }
}

