/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppState;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class RestartRunModeAction
implements IObjectActionDelegate,
IViewActionDelegate,
IActionDelegate2 {
    protected CodewindEclipseApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.getProjectCapabilities().canRestart()) {
                action.setEnabled(this.app.getAppState() == AppState.STARTED || this.app.getAppState() == AppState.STARTING);
                return;
            }
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"RestartRunModeAction ran but no application was selected");
            return;
        }
        try {
            this.app.clearDebugger();
            this.app.connection.requestProjectRestart((CodewindApplication)this.app, StartMode.RUN.startMode);
        }
        catch (Exception e) {
            Logger.logError((String)("Error initiating restart for project: " + this.app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)Messages.ErrorOnRestartDialogTitle, (String)e.getMessage());
            return;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void dispose() {
    }

    public void init(IAction arg0) {
    }

    public void init(IViewPart arg0) {
    }
}

