/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindConnectionPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCodewindConnectionWizard
extends Wizard
implements INewWizard {
    private NewCodewindConnectionPage newConnectionPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle(Messages.NewConnectionWizard_ShellTitle);
        this.newConnectionPage = new NewCodewindConnectionPage();
        this.addPage((IWizardPage)this.newConnectionPage);
    }

    public boolean canFinish() {
        return this.newConnectionPage.getConnection() != null;
    }

    public boolean performCancel() {
        CodewindConnection connection = this.newConnectionPage.getConnection();
        if (connection != null) {
            connection.close();
        }
        return true;
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        this.newConnectionPage.performFinish();
        ViewHelper.openCodewindExplorerView();
        ViewHelper.refreshCodewindExplorerView(null);
        ViewHelper.expandConnection(this.newConnectionPage.getConnection());
        return true;
    }
}

