/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.console.ProjectTemplateInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCodewindProjectWizard
extends Wizard
implements INewWizard {
    private CodewindConnection connection = null;
    private List<ProjectTemplateInfo> templateList = null;
    private NewCodewindProjectPage newProjectPage = null;

    public NewCodewindProjectWizard() {
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public NewCodewindProjectWizard(CodewindConnection connection, List<ProjectTemplateInfo> templateList) {
        this();
        this.connection = connection;
        this.templateList = templateList;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void addPages() {
        Display display = Display.getDefault();
        Shell result = display.getActiveShell();
        try {
            if (CodewindInstall.isCodewindInstalled()) {
                this.setWindowTitle(Messages.NewProjectPage_ShellTitle);
                this.newProjectPage = new NewCodewindProjectPage(this.connection, this.templateList);
                this.addPage((IWizardPage)this.newProjectPage);
            } else {
                result.close();
                CodewindInstall.codewindInstallerDialog();
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean performCancel() {
        CodewindConnection newConnection = this.newProjectPage.getConnection();
        if (newConnection != null && CodewindConnectionManager.getActiveConnection((String)newConnection.baseUrl.toString()) == null) {
            newConnection.close();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        final ProjectTemplateInfo info = this.newProjectPage.getProjectTemplateInfo();
        final String name = this.newProjectPage.getProjectName();
        final CodewindConnection newConnection = this.newProjectPage.getConnection();
        if (info == null || name == null || newConnection == null) {
            Logger.logError((String)"The connection, project type or name was null for the new project wizard");
            return false;
        }
        Job job = new Job("Creating Codewind project: " + name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    newConnection.requestProjectCreate(info, name);
                    newConnection.requestProjectBind(name, newConnection.getWorkspacePath() + "/" + name, info.getLanguage(), info.getProjectType());
                    if (CodewindConnectionManager.getActiveConnection((String)newConnection.baseUrl.toString()) == null) {
                        CodewindConnectionManager.add((CodewindConnection)newConnection);
                    }
                    newConnection.refreshApps(null);
                    CodewindApplication app = newConnection.getAppByName(name);
                    if (app != null) {
                        ImportProjectAction.importProject(app);
                    } else {
                        Logger.logError((String)("Could not get the application for import: " + name));
                    }
                    ViewHelper.openCodewindExplorerView();
                    ViewHelper.refreshCodewindExplorerView(newConnection);
                    ViewHelper.expandConnection(newConnection);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to create a project with type: " + info.getUrl() + ", and name: " + name), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NewProjectPage_ProjectCreateErrorMsg, (Object)name), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }
}

