/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectTypeSelectionPage
extends WizardPage {
    private CodewindConnection connection = null;
    private IProject project = null;
    private Map<String, Set<String>> typeMap;
    private String type = null;
    private String language = null;
    private Text languageLabel = null;
    private CheckboxTableViewer languageViewer = null;
    private Text typeLabel = null;
    private CheckboxTableViewer typeViewer = null;

    protected ProjectTypeSelectionPage(CodewindConnection connection, IProject project) {
        super(Messages.SelectProjectTypePageName);
        this.setTitle(Messages.SelectProjectTypePageTitle);
        this.setDescription(Messages.SelectProjectTypePageDescription);
        this.connection = connection;
        this.project = project;
        this.typeMap = this.getProjectTypeMap();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.typeMap == null || this.typeMap.isEmpty()) {
            Text errorLabel = new Text(composite, 72);
            errorLabel.setText(Messages.SelectProjectTypeErrorLabel);
            this.setControl((Control)composite);
            return;
        }
        this.typeLabel = new Text(composite, 8);
        this.typeLabel.setText(Messages.SelectProjectTypePageProjectTypeLabel);
        this.typeLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.typeLabel.setBackground(composite.getBackground());
        this.typeLabel.setForeground(composite.getForeground());
        this.typeViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTypeLabelProvider());
        this.typeViewer.setInput((Object)this.getProjectTypeArray());
        this.typeViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        this.languageLabel = new Text(composite, 8);
        this.languageLabel.setText(Messages.SelectProjectTypePageLanguageLabel);
        this.languageLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.languageLabel.setBackground(composite.getBackground());
        this.languageLabel.setForeground(composite.getForeground());
        this.languageViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.languageViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageViewer.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.languageViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        this.typeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.typeViewer.setCheckedElements(new Object[]{event.getElement()});
                    ProjectTypeSelectionPage.this.type = (String)event.getElement();
                } else {
                    ProjectTypeSelectionPage.this.type = null;
                }
                String[] languages = ProjectTypeSelectionPage.this.getLanguageArray(ProjectTypeSelectionPage.this.type);
                if (languages != null && languages.length > 1) {
                    ProjectTypeSelectionPage.this.language = null;
                    ProjectTypeSelectionPage.this.languageLabel.setVisible(true);
                    ProjectTypeSelectionPage.this.languageViewer.setInput((Object)languages);
                    ProjectTypeSelectionPage.this.languageViewer.getTable().setVisible(true);
                } else {
                    if (languages.length == 1) {
                        ProjectTypeSelectionPage.this.language = languages[0];
                    } else {
                        ProjectTypeSelectionPage.this.language = null;
                    }
                    ProjectTypeSelectionPage.this.languageLabel.setVisible(false);
                    ProjectTypeSelectionPage.this.languageViewer.getTable().setVisible(false);
                }
                ProjectTypeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.languageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.languageViewer.setCheckedElements(new Object[]{event.getElement()});
                    ProjectTypeSelectionPage.this.language = (String)event.getElement();
                } else {
                    ProjectTypeSelectionPage.this.language = null;
                }
                ProjectTypeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.languageLabel.setVisible(false);
        this.languageViewer.getTable().setVisible(false);
        this.updateTables();
        this.typeViewer.getTable().setFocus();
        this.setControl((Control)composite);
    }

    public boolean canFinish() {
        return this.type != null;
    }

    private String[] getProjectTypeArray() {
        Set<String> typeSet = this.typeMap.keySet();
        String[] types = typeSet.toArray(new String[typeSet.size()]);
        Arrays.sort(types, new Comparator<String>(){

            @Override
            public int compare(String t1, String t2) {
                return ProjectTypeSelectionPage.this.getTypeDisplayName(t1).compareToIgnoreCase(ProjectTypeSelectionPage.this.getTypeDisplayName(t2));
            }
        });
        return types;
    }

    private String[] getLanguageArray(String type) {
        Set<String> languageSet = this.typeMap.get(type);
        if (languageSet == null || languageSet.isEmpty()) {
            return new String[0];
        }
        String[] languages = languageSet.toArray(new String[languageSet.size()]);
        Arrays.sort(languages, new Comparator<String>(){

            @Override
            public int compare(String l1, String l2) {
                return ProjectTypeSelectionPage.this.getLanguageDisplayName(l1).compareToIgnoreCase(ProjectTypeSelectionPage.this.getLanguageDisplayName(l2));
            }
        });
        return languages;
    }

    private String getTypeDisplayName(String typeId) {
        ProjectType type = ProjectType.getType((String)typeId);
        if (type != null && type != ProjectType.TYPE_UNKNOWN) {
            return type.getDisplayName();
        }
        return typeId;
    }

    private String getLanguageDisplayName(String languageId) {
        ProjectLanguage language = ProjectLanguage.getLanguage((String)languageId);
        if (language != null && language != ProjectLanguage.LANGUAGE_UNKNOWN) {
            return language.getDisplayName();
        }
        return languageId;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.updateTables();
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public String getType() {
        if (this.type == null) {
            Logger.logError((String)"The project type is null on the project type selection page");
            return ProjectType.TYPE_UNKNOWN.getId();
        }
        return this.type;
    }

    public String getLanguage() {
        if (this.language == null) {
            return ProjectLanguage.LANGUAGE_UNKNOWN.getId();
        }
        return this.language;
    }

    private void updateTables() {
        ProjectInfo projectInfo = this.getProjectInfo();
        if (projectInfo != null) {
            this.type = projectInfo.type.getId();
            this.language = projectInfo.language.getId();
            this.typeViewer.setCheckedElements(new Object[]{this.type});
            String[] languages = this.getLanguageArray(this.type);
            if (languages != null && languages.length > 1) {
                this.languageLabel.setVisible(true);
                this.languageViewer.setInput((Object)languages);
                this.languageViewer.setCheckedElements(new Object[]{this.language});
                this.languageViewer.getTable().setVisible(true);
            } else {
                this.languageLabel.setVisible(false);
                this.languageViewer.getTable().setVisible(false);
            }
        }
    }

    ProjectInfo getProjectInfo() {
        if (this.connection == null || this.project == null) {
            return null;
        }
        try {
            return this.connection.requestProjectValidate(this.project.getLocation().toFile().getAbsolutePath());
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the project type for project: " + this.project.getName()), (Throwable)e);
            return null;
        }
    }

    private Map<String, Set<String>> getProjectTypeMap() {
        List templates = null;
        HashMap<String, Set<String>> typeMap = new HashMap<String, Set<String>>();
        try {
            templates = this.connection.requestProjectTemplates();
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the list of templates for connection: " + this.connection.baseUrl), (Throwable)e);
            return null;
        }
        if (templates == null || templates.isEmpty()) {
            Logger.logError((String)("Could not get the list of templates for connection: " + this.connection.baseUrl));
            return null;
        }
        for (ProjectTemplateInfo template : templates) {
            HashSet<String> languages = (HashSet<String>)typeMap.get(template.getProjectType());
            if (languages == null) {
                languages = new HashSet<String>();
                typeMap.put(template.getProjectType(), languages);
            }
            if (template.getLanguage() == null || template.getLanguage().isEmpty()) continue;
            languages.add(template.getLanguage());
        }
        return typeMap;
    }

    private class LanguageLabelProvider
    extends LabelProvider {
        private LanguageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ProjectTypeSelectionPage.this.getLanguageDisplayName((String)element);
        }
    }

    private class ProjectTypeLabelProvider
    extends LabelProvider {
        private ProjectTypeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ProjectTypeSelectionPage.this.getTypeDisplayName((String)element);
        }
    }
}

