/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { HttpPostOutputQueue } from "./HttpPostOutputQueue";
import { PostQueueChunk } from "./PostQueueChunk";
export declare enum ChunkStatus {
    AVAILABLE_TO_SEND = 0,
    WAITING_FOR_ACK = 1,
    COMPLETE = 2
}
export declare class PostQueueChunkGroup {
    private readonly _chunkMap;
    private readonly _chunkStatus;
    private readonly _parent;
    private readonly _timestamp;
    constructor(timestamp: number, projectId: string, base64Compressed: string[], parent: HttpPostOutputQueue);
    /** A group is complete if every chunk is ChunkStatus.COMPLETE */
    isGroupComplete(): boolean;
    informPacketSent(chunk: PostQueueChunk): void;
    informPacketFailedToSend(chunk: PostQueueChunk): void;
    /** Returns the next chunk to be sent, or empty if none are currently available. */
    acquireNextChunkAvailableToSend(): PostQueueChunk;
    readonly timestamp: number;
}
