/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class InstallerAction
extends SelectionProviderAction {
    public final ActionType actionType;

    public InstallerAction(ActionType actionType, ISelectionProvider selectionProvider) {
        super(selectionProvider, actionType.disableLabel);
        this.actionType = actionType;
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindManager) {
            InstallStatus status = CodewindManager.getManager().getInstallStatus(false);
            if (this.actionType == ActionType.INSTALL_UNINSTALL) {
                if (status.isInstalled()) {
                    this.setText(this.actionType.disableLabel);
                    this.setEnabled(true);
                } else if (status.hasInstalledVersions()) {
                    this.setText(Messages.InstallerActionUpdateLabel);
                    this.setEnabled(true);
                } else if (status.isUnknown()) {
                    this.setText(this.actionType.enableLabel);
                    this.setEnabled(false);
                } else {
                    this.setText(this.actionType.enableLabel);
                    this.setEnabled(true);
                }
                return;
            }
            if (status.isStarted()) {
                this.setText(this.actionType.disableLabel);
                this.setEnabled(true);
            } else if (status.isInstalled()) {
                this.setText(this.actionType.enableLabel);
                this.setEnabled(true);
            } else if (status.isUnknown()) {
                this.setText(this.actionType.enableLabel);
                this.setEnabled(false);
            } else {
                this.setText(this.actionType.enableLabel);
                this.setEnabled(false);
            }
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        InstallStatus status = CodewindManager.getManager().getInstallStatus(false);
        if (this.actionType == ActionType.INSTALL_UNINSTALL) {
            if (Messages.InstallerActionUpdateLabel.equals(this.getText())) {
                boolean result = IDEUtil.openConfirmDialog(Messages.UpdateCodewindDialogTitle, Messages.UpdateCodewindDialogMsg);
                if (result) {
                    CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, null);
                }
            } else if (this.actionType.enableLabel.equals(this.getText())) {
                CodewindInstall.installCodewind(InstallUtil.getVersion(), null);
            } else {
                CodewindInstall.removeCodewind(status.getVersion());
            }
        } else if (this.actionType.enableLabel.equals(this.getText())) {
            CodewindInstall.startCodewind(status.getVersion(), null);
        } else {
            CodewindInstall.stopCodewind();
        }
    }

    public static enum ActionType {
        INSTALL_UNINSTALL(Messages.InstallerActionInstallLabel, Messages.InstallerActionUninstallLabel),
        START_STOP(Messages.InstallerActionStartLabel, Messages.InstallerActionStopLabel);

        public final String enableLabel;
        public final String disableLabel;

        private ActionType(String onLabel, String offLabel) {
            this.enableLabel = onLabel;
            this.disableLabel = offLabel;
        }
    }
}

