/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.editors;

import java.net.URL;
import java.util.Date;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorInput;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.UpdateHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class ApplicationOverviewEditorPart
extends EditorPart {
    private static final String SETTINGS_FILE = ".cw-settings";
    private static final String JSON_EDITOR_ID = "org.eclipse.wst.json.ui.JSONEditor";
    private static final String CWSETTINGS_INFO_URL = "https://www.eclipse.org/codewind/mdteclipsemanagingprojects.html";
    private static final String CWSETTINGS_INFO_ID = "org.eclipse.codewind.ui.overview.ProjectSettingsInfo";
    private Composite contents;
    private String appName;
    private String projectID;
    private CodewindConnection connection;
    private ScrolledForm form = null;
    private GeneralSection generalSection = null;
    private ProjectSettingsSection projectSettingsSection = null;
    private BuildSection buildSection = null;

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        CodewindApplication application = null;
        if (input instanceof ApplicationOverviewEditorInput && CodewindManager.getManager().getInstallStatus(false).isStarted()) {
            ApplicationOverviewEditorInput appInput = (ApplicationOverviewEditorInput)input;
            if (appInput.connectionUri != null && appInput.projectID != null) {
                this.connection = CodewindConnectionManager.getActiveConnection((String)appInput.connectionUri);
                if (this.connection != null) {
                    application = this.connection.getAppByID(appInput.projectID);
                }
            }
        }
        if (application == null) {
            Logger.logError((String)("Could not retreive the application from the editor input: " + input.getClass()));
            throw new PartInitException(NLS.bind((String)Messages.AppOverviewEditorCreateError, (Object)input));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.appName = application.name;
        this.projectID = application.projectID;
        this.setPartName(NLS.bind((String)Messages.AppOverviewEditorPartName, (Object)this.appName));
        CodewindUIPlugin.getUpdateHandler().addAppUpdateListener(this.projectID, new UpdateHandler.AppUpdateListener(){

            @Override
            public void update(final CodewindApplication app) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationOverviewEditorPart.this.update(app);
                    }
                });
            }

            @Override
            public void remove(CodewindApplication app) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationOverviewEditorPart.this.getEditorSite().getPage().closeEditor((IEditorPart)ApplicationOverviewEditorPart.this, false);
                    }
                });
            }
        });
    }

    public void dispose() {
        CodewindUIPlugin.getUpdateHandler().removeAppUpdateListener(this.projectID);
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        ManagedForm managedForm = new ManagedForm(parent);
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.form.getForm());
        this.form.setText(this.appName);
        this.form.setImage(CodewindUIPlugin.getImage("codewind.ico"));
        this.form.getBody().setLayout((Layout)new GridLayout());
        Composite columnComp = toolkit.createComposite(this.form.getBody());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        columnComp.setLayout((Layout)layout);
        columnComp.setLayoutData((Object)new GridData(784));
        Composite leftColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        leftColumnComp.setLayout((Layout)layout);
        GridData data = new GridData(784);
        data.widthHint = 120;
        leftColumnComp.setLayoutData((Object)data);
        this.generalSection = new GeneralSection(leftColumnComp, toolkit);
        Composite rightColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        rightColumnComp.setLayout((Layout)layout);
        rightColumnComp.setLayoutData((Object)new GridData(784));
        this.projectSettingsSection = new ProjectSettingsSection(rightColumnComp, toolkit);
        this.buildSection = new BuildSection(rightColumnComp, toolkit);
        Button refreshButton = new Button(columnComp, 8);
        refreshButton.setText(Messages.AppOverviewEditorRefreshButton);
        refreshButton.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                final CodewindApplication app = ApplicationOverviewEditorPart.this.getApp();
                if (app == null) {
                    Logger.logError((String)("Could not get the application for refreshing project: " + ApplicationOverviewEditorPart.this.appName));
                    return;
                }
                Job job = new Job(NLS.bind((String)Messages.RefreshProjectJobLabel, (Object)app.name)){

                    protected IStatus run(IProgressMonitor monitor) {
                        app.connection.refreshApps(app.projectID);
                        Display.getDefault().asyncExec(() -> ApplicationOverviewEditorPart.this.update(app));
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        this.update(this.getApp());
    }

    public void update(CodewindApplication app) {
        this.generalSection.update(app);
        this.projectSettingsSection.update(app);
        this.buildSection.update(app);
        this.form.layout(true, true);
        this.form.reflow(true);
    }

    public void enableWidgets(boolean enable) {
        this.generalSection.enableWidgets(enable);
        this.projectSettingsSection.enableWidgets(enable);
        this.buildSection.enableWidgets(enable);
        this.form.reflow(true);
    }

    private CodewindApplication getApp() {
        return this.connection.getAppByID(this.projectID);
    }

    private String formatTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        return date.toLocaleString();
    }

    private void addSpacer(Composite composite) {
        new Label(composite, 0);
    }

    private void setBold(StyledText text) {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = text.getText().length();
        range.fontStyle = 1;
        text.setStyleRange(range);
    }

    public void setFocus() {
        if (this.contents != null) {
            this.contents.setFocus();
        }
    }

    public static interface LinkAction {
        public void execute(String var1);
    }

    private class LinkEntry {
        private final Text text;
        private final Hyperlink link;
        private String linkUrl;

        public LinkEntry(Composite composite, FormToolkit toolkit, String name, final LinkAction action) {
            StyledText label = new StyledText(composite, 12);
            label.setText(name);
            ApplicationOverviewEditorPart.this.setBold(label);
            this.text = new Text(composite, 74);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(Messages.AppOverviewEditorNotAvailable);
            this.text.setLayoutData((Object)new GridData(1, 2, false, false));
            this.link = toolkit.createHyperlink(composite, "", 64);
            this.link.setVisible(false);
            GridData data = new GridData(1, 2, true, false);
            data.exclude = true;
            this.link.setLayoutData((Object)data);
            this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    action.execute(LinkEntry.this.linkUrl);
                }
            });
        }

        public void setValue(String linkUrl, boolean enabled) {
            this.linkUrl = linkUrl;
            if (linkUrl != null && !linkUrl.isEmpty()) {
                this.link.setText(linkUrl);
                this.link.setVisible(true);
                ((GridData)this.link.getLayoutData()).exclude = false;
                this.text.setVisible(false);
                ((GridData)this.text.getLayoutData()).exclude = true;
                this.link.setEnabled(enabled);
            } else {
                this.link.setVisible(false);
                ((GridData)this.link.getLayoutData()).exclude = true;
                this.text.setVisible(true);
                ((GridData)this.text.getLayoutData()).exclude = false;
            }
        }
    }

    public static interface BooleanAction {
        public void execute(boolean var1);
    }

    private class BooleanEntry {
        private final String onText;
        private final String offText;
        private final Button button;

        public BooleanEntry(Composite composite, String name, Image image, final String onText, final String offText, final BooleanAction action) {
            this.onText = onText;
            this.offText = offText;
            StyledText label = new StyledText(composite, 12);
            label.setText(name);
            ApplicationOverviewEditorPart.this.setBold(label);
            this.button = new Button(composite, 2);
            this.button.setText(onText.length() > offText.length() ? onText : offText);
            if (image != null) {
                this.button.setImage(image);
            }
            GridData data = new GridData(1, 2, false, false);
            data.widthHint = this.button.computeSize((int)-1, (int)-1, (boolean)true).x;
            this.button.setLayoutData((Object)data);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BooleanEntry.this.button.setText(BooleanEntry.this.button.getSelection() ? onText : offText);
                    action.execute(BooleanEntry.this.button.getSelection());
                }
            });
        }

        public void setValue(boolean value, boolean enabled) {
            this.button.setSelection(value);
            this.button.setText(value ? this.onText : this.offText);
            this.button.setEnabled(enabled);
        }

        public void enableEntry(boolean enable) {
            this.button.setEnabled(enable);
        }
    }

    private class StringEntry {
        private final Text text;

        public StringEntry(Composite composite, String name) {
            StyledText label = new StyledText(composite, 12);
            label.setText(name);
            ApplicationOverviewEditorPart.this.setBold(label);
            this.text = new Text(composite, 74);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        public void setValue(String value, boolean enabled) {
            this.text.setText(value != null && !value.isEmpty() ? value : Messages.AppOverviewEditorNotAvailable);
        }
    }

    private class BuildSection {
        private final StringEntry autoBuildEntry;
        private final StringEntry lastBuildEntry;
        private final StringEntry lastImageBuildEntry;

        public BuildSection(Composite parent, FormToolkit toolkit) {
            Section section = toolkit.createSection(parent, 386);
            section.setText(Messages.AppOverviewEditorBuildSection);
            section.setLayoutData((Object)new GridData(784));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.autoBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorAutoBuildEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.lastBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorLastBuildEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.lastImageBuildEntry = new StringEntry(composite, Messages.AppOverviewEditorLastImageBuildEntry);
        }

        public void update(CodewindApplication app) {
            this.autoBuildEntry.setValue(app.isAutoBuild() ? Messages.AppOverviewEditorAutoBuildOn : Messages.AppOverviewEditorAutoBuildOff, app.isAvailable());
            long lastBuild = app.getLastBuild();
            String lastBuildStr = Messages.AppOverviewEditorProjectNeverBuilt;
            if (lastBuild > 0L) {
                lastBuildStr = ApplicationOverviewEditorPart.this.formatTimestamp(lastBuild);
            }
            this.lastBuildEntry.setValue(lastBuildStr, true);
            long lastImageBuild = app.getLastImageBuild();
            String lastImageBuildStr = Messages.AppOverviewEditorImageNeverBuilt;
            if (lastImageBuild > 0L) {
                lastImageBuildStr = ApplicationOverviewEditorPart.this.formatTimestamp(lastBuild);
            }
            this.lastImageBuildEntry.setValue(lastImageBuildStr, true);
        }

        public void enableWidgets(boolean enable) {
        }
    }

    private class ProjectSettingsSection {
        private final StringEntry contextRootEntry;
        private final StringEntry appPortEntry;
        private final StringEntry debugPortEntry;
        private final Button editButton;
        private final Button infoButton;

        public ProjectSettingsSection(final Composite parent, FormToolkit toolkit) {
            Section section = toolkit.createSection(parent, 386);
            section.setText(Messages.AppOverviewEditorProjectSettingsSection);
            section.setLayoutData((Object)new GridData(784));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.contextRootEntry = new StringEntry(composite, Messages.AppOverviewEditorContextRootEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.appPortEntry = new StringEntry(composite, Messages.AppOverviewEditorAppPortEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.debugPortEntry = new StringEntry(composite, Messages.AppOverviewEditorDebugPortEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            Composite buttonComp = toolkit.createComposite(composite);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            buttonComp.setLayout((Layout)layout);
            buttonComp.setLayoutData((Object)new GridData(3, 3, false, false));
            this.editButton = new Button(buttonComp, 8);
            this.editButton.setText(Messages.AppOverviewEditorEditProjectSettings);
            this.editButton.setLayoutData((Object)new GridData(3, 2, false, false));
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IFile file;
                    CodewindApplication app = ApplicationOverviewEditorPart.this.getApp();
                    if (app == null) {
                        Logger.logError((String)("Trying to open the settings file from the overview page but the app is not found with name: " + ApplicationOverviewEditorPart.this.appName + ", and project id: " + ApplicationOverviewEditorPart.this.projectID));
                        return;
                    }
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(app.name);
                    if (project != null && project.isAccessible() && (file = project.getFile(ApplicationOverviewEditorPart.SETTINGS_FILE)) != null && file.exists()) {
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)ApplicationOverviewEditorPart.JSON_EDITOR_ID);
                        }
                        catch (PartInitException e) {
                            Logger.logError((String)("Error trying to open project settings file: " + file), (Throwable)e);
                            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)NLS.bind((String)Messages.AppOverviewEditorOpenSettingsErrorMsg, (Object)((Object)e)));
                        }
                        return;
                    }
                    IPath path = app.fullLocalPath.append(ApplicationOverviewEditorPart.SETTINGS_FILE);
                    if (path.toFile().exists()) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
                        FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)ApplicationOverviewEditorPart.JSON_EDITOR_ID);
                        }
                        catch (PartInitException e) {
                            Logger.logError((String)("Error trying to open project settings file: " + path.toOSString()), (Throwable)e);
                            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)NLS.bind((String)Messages.AppOverviewEditorOpenSettingsErrorMsg, (Object)((Object)e)));
                        }
                        return;
                    }
                    Logger.logError((String)("Failed to open project settings file for project: " + ApplicationOverviewEditorPart.this.appName + ", with id: " + ApplicationOverviewEditorPart.this.projectID));
                    MessageDialog.openError((Shell)parent.getShell(), (String)Messages.AppOverviewEditorOpenSettingsErrorTitle, (String)Messages.AppOverviewEditorOpenSettingsNotFound);
                }
            });
            this.infoButton = new Button(buttonComp, 8);
            this.infoButton.setText(Messages.AppOverviewEditorProjectSettingsInfo);
            this.infoButton.setLayoutData((Object)new GridData(3, 2, false, false));
            this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(6, ApplicationOverviewEditorPart.CWSETTINGS_INFO_ID, null, null);
                        URL url = new URL(ApplicationOverviewEditorPart.CWSETTINGS_INFO_URL);
                        browser.openURL(url);
                    }
                    catch (Exception e) {
                        Logger.logError((String)"Failed to open the browser for the project settings documentation: https://www.eclipse.org/codewind/mdteclipsemanagingprojects.html", (Throwable)e);
                    }
                }
            });
        }

        public void update(CodewindApplication app) {
            this.contextRootEntry.setValue(app.getContextRoot() != null ? app.getContextRoot() : "/", true);
            this.appPortEntry.setValue(app.getContainerAppPort(), true);
            String debugPort = null;
            debugPort = app.supportsDebug() ? app.getContainerDebugPort() : Messages.AppOverviewEditorDebugNotSupported;
            this.debugPortEntry.setValue(debugPort, true);
        }

        public void enableWidgets(boolean enable) {
        }
    }

    private class GeneralSection {
        private final StringEntry typeEntry;
        private final StringEntry languageEntry;
        private final StringEntry locationEntry;
        private final LinkEntry appURLEntry;
        private final StringEntry hostAppPortEntry;
        private final StringEntry hostDebugPortEntry;
        private final StringEntry projectIdEntry;
        private final StringEntry containerIdEntry;
        private final StringEntry statusEntry;

        public GeneralSection(Composite parent, FormToolkit toolkit) {
            Section section = toolkit.createSection(parent, 386);
            section.setText(Messages.AppOverviewEditorGeneralSection);
            section.setLayoutData((Object)new GridData(784));
            section.setExpanded(true);
            Composite composite = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginHeight = 5;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            toolkit.paintBordersFor(composite);
            section.setClient((Control)composite);
            this.typeEntry = new StringEntry(composite, Messages.AppOverviewEditorTypeEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.languageEntry = new StringEntry(composite, Messages.AppOverviewEditorLanguageEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.locationEntry = new StringEntry(composite, Messages.AppOverviewEditorLocationEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.appURLEntry = new LinkEntry(composite, toolkit, Messages.AppOverviewEditorAppUrlEntry, url -> {
                CodewindApplication app = ApplicationOverviewEditorPart.this.getApp();
                if (app == null) {
                    Logger.logError((String)("Could not get the application for opening in a browser: " + ApplicationOverviewEditorPart.this.appName));
                    return;
                }
                OpenAppAction.openAppInBrowser(app);
            });
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.hostAppPortEntry = new StringEntry(composite, Messages.AppOverviewEditorHostAppPortEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.hostDebugPortEntry = new StringEntry(composite, Messages.AppOverviewEditorHostDebugPortEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.projectIdEntry = new StringEntry(composite, Messages.AppOverviewEditorProjectIdEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.containerIdEntry = new StringEntry(composite, Messages.AppOverviewEditorContainerIdEntry);
            ApplicationOverviewEditorPart.this.addSpacer(composite);
            this.statusEntry = new StringEntry(composite, Messages.AppOverviewEditorStatusEntry);
        }

        public void update(CodewindApplication app) {
            this.typeEntry.setValue(app.projectType.getDisplayName(), true);
            this.languageEntry.setValue(app.projectLanguage.getDisplayName(), true);
            this.locationEntry.setValue(app.fullLocalPath.toOSString(), true);
            this.appURLEntry.setValue(app.isAvailable() && app.getRootUrl() != null ? app.getRootUrl().toString() : null, true);
            this.hostAppPortEntry.setValue(app.isAvailable() && app.getHttpPort() > 0 ? Integer.toString(app.getHttpPort()) : null, true);
            String hostDebugPort = null;
            hostDebugPort = app.supportsDebug() ? (app.isAvailable() && app.getDebugPort() > 0 ? Integer.toString(app.getDebugPort()) : null) : Messages.AppOverviewEditorDebugNotSupported;
            this.hostDebugPortEntry.setValue(hostDebugPort, true);
            this.projectIdEntry.setValue(app.projectID, true);
            this.containerIdEntry.setValue(app.isAvailable() ? app.getContainerId() : null, true);
            this.statusEntry.setValue(app.isAvailable() ? Messages.AppOverviewEditorStatusEnabled : Messages.AppOverviewEditorStatusDisabled, true);
        }

        public void enableWidgets(boolean enable) {
        }
    }
}

