/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.ProjectSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectTypeSelectionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BindProjectWizard
extends Wizard
implements INewWizard {
    private ProjectSelectionPage projectPage;
    private ProjectTypeSelectionPage projectTypePage;
    private final CodewindConnection connection;
    private IProject project = null;

    public BindProjectWizard(CodewindConnection connection) {
        this.connection = connection;
        this.init();
    }

    public BindProjectWizard(CodewindConnection connection, IProject project) {
        this.connection = connection;
        this.project = project;
        this.init();
    }

    private void init() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.BindProjectWizardTitle);
        if (this.project == null) {
            this.projectPage = new ProjectSelectionPage(this, this.connection);
            this.addPage((IWizardPage)this.projectPage);
        }
        this.projectTypePage = new ProjectTypeSelectionPage(this.connection, this.project);
        this.addPage((IWizardPage)this.projectTypePage);
    }

    public boolean canFinish() {
        boolean canFinish = this.projectTypePage.canFinish();
        if (this.projectPage != null) {
            canFinish &= this.projectPage.canFinish();
        }
        return canFinish;
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        if (this.projectPage != null) {
            this.project = this.projectPage.getProject();
        }
        Job job = new Job(NLS.bind((String)Messages.BindProjectWizardJobLabel, (Object)this.project.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BindProjectWizard.this.connection.requestProjectBind(BindProjectWizard.this.project.getName(), BindProjectWizard.this.project.getLocation().toFile().getAbsolutePath(), BindProjectWizard.this.projectTypePage.getLanguage(), BindProjectWizard.this.projectTypePage.getType());
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to add the project to Codewind: " + BindProjectWizard.this.project.getName()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardError, (Object)BindProjectWizard.this.project.getName()), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }

    public void setProject(IProject project) {
        if (this.projectTypePage != null) {
            this.projectTypePage.setProject(project);
        }
    }
}

