/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewCodewindConnectionPage
extends WizardPage {
    private Text hostnameText;
    private Text portText;
    private CodewindConnection connection;

    protected NewCodewindConnectionPage() {
        super(Messages.NewConnectionPage_ShellTitle);
        this.setTitle(Messages.NewConnectionPage_WizardTitle);
        this.setDescription(Messages.NewConnectionPage_WizardDescription);
    }

    public void createControl(Composite parent) {
        Composite shell = new Composite(parent, 0);
        shell.setLayout((Layout)new GridLayout());
        this.createHostnameAndPortFields(shell);
        this.setControl((Control)shell);
    }

    private void createHostnameAndPortFields(Composite shell) {
        Composite hostPortGroup = new Composite(shell, 0);
        hostPortGroup.setLayout((Layout)new GridLayout(3, false));
        hostPortGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData hostnamePortLabelData = new GridData(4, 4, false, false);
        Label hostnameLabel = new Label(hostPortGroup, 0);
        hostnameLabel.setText(Messages.NewConnectionPage_HostnameLabel);
        hostnameLabel.setLayoutData((Object)hostnamePortLabelData);
        this.hostnameText = new Text(hostPortGroup, 2056);
        GridData hostnamePortTextData = new GridData(4, 1, true, false, 2, 1);
        this.hostnameText.setLayoutData((Object)hostnamePortTextData);
        Color bg = this.hostnameText.getBackground();
        Color fg = this.hostnameText.getForeground();
        final Color gray = new Color(bg.getDevice(), (bg.getRed() + fg.getRed()) / 2, (bg.getGreen() + fg.getGreen()) / 2, (bg.getBlue() + fg.getBlue()) / 2);
        this.hostnameText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                gray.dispose();
            }
        });
        this.hostnameText.setForeground(gray);
        this.hostnameText.setText("localhost");
        String localhostOnly = Messages.NewConnectionPage_OnlyLocalhostSupported;
        hostnameLabel.setToolTipText(localhostOnly);
        this.hostnameText.setToolTipText(localhostOnly);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewCodewindConnectionPage.this.removePreviousConnection();
                NewCodewindConnectionPage.this.setErrorMessage(null);
                NewCodewindConnectionPage.this.setMessage(Messages.NewConnectionPage_TestToProceed);
                NewCodewindConnectionPage.this.getWizard().getContainer().updateButtons();
            }
        };
        this.hostnameText.addModifyListener(modifyListener);
        Label portLabel = new Label(hostPortGroup, 0);
        portLabel.setText(Messages.NewConnectionPage_PortLabel);
        portLabel.setLayoutData((Object)hostnamePortLabelData);
        this.portText = new Text(hostPortGroup, 2048);
        this.portText.setLayoutData((Object)hostnamePortTextData);
        this.portText.setText("9090");
        this.portText.addModifyListener(modifyListener);
        final Button testConnectionBtn = new Button(hostPortGroup, 8);
        testConnectionBtn.setText(Messages.NewConnectionPage_TestConnectionBtn);
        testConnectionBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                testConnectionBtn.setEnabled(false);
                NewCodewindConnectionPage.this.testConnection();
                testConnectionBtn.setEnabled(true);
                testConnectionBtn.setFocus();
            }
        });
        testConnectionBtn.setLayoutData((Object)new GridData(1, 2, false, false));
        if (CodewindConnectionManager.activeConnectionsCount() > 0) {
            testConnectionBtn.setEnabled(false);
            String existingConnectionUrl = ((CodewindConnection)CodewindConnectionManager.activeConnections().get((int)0)).baseUrl.toString();
            this.setErrorMessage(NLS.bind((String)Messages.NewConnectionPage_ErrAConnectionAlreadyExists, (Object)existingConnectionUrl));
        } else {
            testConnectionBtn.setFocus();
        }
    }

    void removePreviousConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    void testConnection() {
        this.removePreviousConnection();
        String hostname = this.hostnameText.getText().trim();
        String portStr = this.portText.getText().trim();
        URI uri = null;
        try {
            int port = Integer.parseInt(portStr);
            uri = CodewindConnection.buildUrl((String)hostname, (int)port);
        }
        catch (NumberFormatException e) {
            Logger.logError((Throwable)e);
            this.setErrorMessage(NLS.bind((String)Messages.NewConnectionPage_NotValidPortNum, (Object)portStr));
        }
        catch (URISyntaxException e) {
            Logger.logError((Throwable)e);
            this.setErrorMessage(e.getMessage());
        }
        if (uri == null) {
            return;
        }
        Logger.log((String)("Validating connection: " + uri));
        this.connection = this.createConnection(uri);
        if (this.connection != null) {
            this.setErrorMessage(null);
            this.setMessage(NLS.bind((String)Messages.NewConnectionPage_ConnectSucceeded, (Object)this.connection.baseUrl));
        } else {
            this.setErrorMessage(NLS.bind((String)Messages.NewConnectionPage_ErrCouldNotConnectToMC, (Object)uri));
        }
        this.getWizard().getContainer().updateButtons();
    }

    CodewindConnection getConnection() {
        return this.connection;
    }

    void performFinish() {
        if (this.connection != null) {
            CodewindConnectionManager.add((CodewindConnection)this.connection);
        }
    }

    private CodewindConnection createConnection(URI uri) {
        try {
            return CodewindObjectFactory.createCodewindConnection((URI)uri);
        }
        catch (Exception exception) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        InstallStatus status = CodewindManager.getManager().getInstallStatus(false);
                        ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                        if (result.getExitValue() != 0) {
                            Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                            String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                            throw new InvocationTargetException(null, "There was a problem while trying to start Codewind: " + errorText);
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                    }
                    catch (TimeoutException e) {
                        throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                    }
                }
            };
            try {
                this.getWizard().getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
                return null;
            }
            catch (InterruptedException e) {
                Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
                return null;
            }
            CodewindConnection connection = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    connection = CodewindObjectFactory.createCodewindConnection((URI)uri);
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (connection == null) {
                Logger.logError((String)("Failed to connect to Codewind at: " + uri.toString()));
            }
            return connection;
        }
    }
}

