/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.codewind.filewatchers.JavaNioWatchService;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.IPlatformWatchService;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;
import org.eclipse.codewind.filewatchers.eclipse.CodewindResourceChangeListener;
import org.eclipse.codewind.filewatchers.eclipse.EclipseResourceWatchService;
import org.eclipse.codewind.filewatchers.eclipse.ICodewindProjectTranslator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class CodewindFilewatcherdConnection {
    private final String baseHttpUrl;
    private final Filewatcher fileWatcher;
    private final EclipseResourceWatchService platformWatchService;
    private final CodewindResourceChangeListener listener;
    private final ICodewindProjectTranslator translator;
    private final String clientUuid = UUID.randomUUID().toString();

    public CodewindFilewatcherdConnection(String baseHttpUrl, ICodewindProjectTranslator translator) {
        String url = baseHttpUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("Argument should begin with http:// or https://.");
        }
        File metadataDirectory = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getPath(), ".metadata");
        FWLogger logger = FWLogger.getInstance();
        logger.setOutputLogsToScreen(false);
        logger.setRollingFileLoggerOutputDir(metadataDirectory);
        this.translator = translator;
        this.listener = new CodewindResourceChangeListener(this);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.listener);
        this.platformWatchService = new EclipseResourceWatchService();
        this.fileWatcher = new Filewatcher(url, this.clientUuid, (IPlatformWatchService)this.platformWatchService, (IPlatformWatchService)new JavaNioWatchService());
        this.baseHttpUrl = url;
    }

    public String getClientUuid() {
        return this.clientUuid;
    }

    public void dispose() {
        try {
            this.platformWatchService.dispose();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this.listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.fileWatcher.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleResourceChanges(List<FileChangeEntryEclipse> result) {
        if (result == null || result.size() == 0) {
            return;
        }
        HashMap entries = new HashMap();
        result.forEach(e -> {
            Optional<String> o = this.translator.getProjectId(e.getProject());
            if (o.isPresent()) {
                String projectId = o.get();
                List weeList = entries.computeIfAbsent(projectId, f -> new ArrayList());
                weeList.add(e.convertToWatchEvent());
            }
        });
        entries.entrySet().forEach(e -> this.platformWatchService.receiveWatchEntries((String)e.getKey(), (List)e.getValue()));
    }

    public static class FileChangeEntryEclipse {
        private final File f;
        private final ChangeEntryEventType eventType;
        private final boolean isDirectory;
        private final IProject project;

        public FileChangeEntryEclipse(File f, ChangeEntryEventType eventType, boolean isDirectory, IProject project) {
            this.f = f;
            this.eventType = eventType;
            this.isDirectory = isDirectory;
            this.project = project;
        }

        public WatchEventEntry convertToWatchEvent() {
            if (this.eventType == ChangeEntryEventType.CREATE) {
                return new WatchEventEntry(WatchEventEntry.EventType.CREATE, this.f.toPath(), this.isDirectory);
            }
            if (this.eventType == ChangeEntryEventType.DELETE) {
                return new WatchEventEntry(WatchEventEntry.EventType.DELETE, this.f.toPath(), this.isDirectory);
            }
            if (this.eventType == ChangeEntryEventType.MODIFY) {
                return new WatchEventEntry(WatchEventEntry.EventType.MODIFY, this.f.toPath(), this.isDirectory);
            }
            throw new IllegalArgumentException("Unknown eventType: " + (Object)((Object)this.eventType));
        }

        public IProject getProject() {
            return this.project;
        }

        public String toString() {
            return this.convertToWatchEvent().toString();
        }

        public static enum ChangeEntryEventType {
            CREATE,
            MODIFY,
            DELETE;

        }
    }
}

