/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URL;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionEnv {
    public static final String CODEWIND_WORKSPACE_PROPERTY = "org.eclipse.codewind.internal.workspace";
    public static final String KEY_VERSION = "codewind_version";
    public static final String UNKNOWN_VERSION = "unknown";
    public static final String KEY_WORKSPACE_LOC = "workspace_location";
    public static final String KEY_SOCKET_NAMESPACE = "socket_namespace";
    public static final String KEY_TEKTON_DASHBOARD_URL = "tekton_dashboard_url";
    public static final String VALUE_TEKTON_DASHBOARD_NOT_INSTALLED = "not-installed";
    public static final String VALUE_TEKTON_DASHBOARD_ERROR = "error";
    private JSONObject env;
    private IPath workspacePath;

    public ConnectionEnv(JSONObject env) {
        this.env = env;
    }

    public String getVersion() {
        String version = this.getString(KEY_VERSION);
        if (version == null) {
            version = UNKNOWN_VERSION;
        }
        return version;
    }

    public IPath getWorkspacePath() {
        if (this.workspacePath == null) {
            String path = System.getProperty(CODEWIND_WORKSPACE_PROPERTY, null);
            if (path != null && !path.isEmpty()) {
                this.workspacePath = new Path(path);
            } else {
                String workspaceLoc = this.getString(KEY_WORKSPACE_LOC);
                if (workspaceLoc == null) {
                    return null;
                }
                if (CoreUtil.isWindows() && workspaceLoc.startsWith("/")) {
                    String device = workspaceLoc.substring(1, 2);
                    workspaceLoc = device + ":" + workspaceLoc.substring(2);
                }
                this.workspacePath = new Path(workspaceLoc);
            }
        }
        return this.workspacePath;
    }

    public String getSocketNamespace() {
        return this.getString(KEY_SOCKET_NAMESPACE);
    }

    public URL getTektonDashboardURL() {
        String urlStr = this.getString(KEY_TEKTON_DASHBOARD_URL);
        if (urlStr == null || urlStr.isEmpty() || urlStr.equals(VALUE_TEKTON_DASHBOARD_NOT_INSTALLED) || urlStr.equals(VALUE_TEKTON_DASHBOARD_ERROR)) {
            return null;
        }
        try {
            return new URL(urlStr);
        }
        catch (Exception e) {
            Logger.logError("The Tekton dashboard URL is not valid: " + urlStr, e);
            return null;
        }
    }

    private String getString(String key) {
        String value = null;
        if (this.env.has(key)) {
            try {
                value = this.env.getString(key);
            }
            catch (JSONException e) {
                Logger.logError("An error occurred retrieving the value from the connection environment object for key: " + key, e);
            }
        } else {
            Logger.logError("The connection environment object did not have the expected key: " + key);
        }
        return value;
    }

    public String toString() {
        return this.env.toString();
    }
}

