/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.SelectionProviderAction;

public class UnbindProjectAction
extends SelectionProviderAction {
    List<CodewindEclipseApplication> apps;

    public UnbindProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.UnbindActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        boolean enabled = false;
        this.apps = new ArrayList<CodewindEclipseApplication>();
        for (Object obj : sel.toList()) {
            if (obj instanceof CodewindEclipseApplication) {
                this.apps.add((CodewindEclipseApplication)obj);
                enabled = true;
                continue;
            }
            enabled = false;
            break;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.apps == null || this.apps.isEmpty()) {
            Logger.logError((String)"UnbindProjectAction ran but no application was selected");
            return;
        }
        String msg = this.apps.size() == 1 ? NLS.bind((String)Messages.UnbindActionMessage, (Object)this.apps.get((int)0).name) : NLS.bind((String)Messages.UnbindActionMultipleMessage, (Object)this.apps.size());
        final RemoveDialog removeDialog = new RemoveDialog(Display.getDefault().getActiveShell(), msg, this.apps);
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = removeDialog.open();
            }
        });
        if (result[0] == 0) {
            final boolean deleteContent = removeDialog.getDeleteContent();
            String jobTitle = this.apps.size() == 1 ? NLS.bind((String)Messages.UnbindActionJobTitle, (Object)this.apps.get((int)0).name) : NLS.bind((String)Messages.UnbindActionMultipleJobTitle, (Object)this.apps.size());
            Job job = new Job(jobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    for (CodewindEclipseApplication app : UnbindProjectAction.this.apps) {
                        try {
                            app.connection.requestProjectUnbind(app.projectID);
                            if (!deleteContent) continue;
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(app.name);
                            if (project != null && project.exists() && project.getLocation().toFile().equals(app.fullLocalPath.toFile())) {
                                project.delete(true, true, monitor);
                                continue;
                            }
                            if (!app.fullLocalPath.toFile().exists()) continue;
                            FileUtil.deleteDirectory((String)app.fullLocalPath.toOSString(), (boolean)true);
                        }
                        catch (Exception e) {
                            Logger.logError((String)("Error requesting application remove: " + app.name), (Throwable)e);
                            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.UnbindActionError, (Object)app.name), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public static class RemoveDialog
    extends MessageDialog {
        List<CodewindEclipseApplication> apps;
        boolean deleteContent = false;

        public RemoveDialog(Shell parentShell, String msg, List<CodewindEclipseApplication> apps) {
            super(parentShell, Messages.UnbindActionTitle, null, msg, 3, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
            this.apps = apps;
        }

        protected Control createCustomArea(Composite parent) {
            Point defaultSpacing = LayoutConstants.getSpacing();
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(1, false);
            layout.horizontalSpacing = defaultSpacing.x * 2;
            layout.verticalSpacing = defaultSpacing.y;
            composite.setLayout((Layout)layout);
            final Button deleteContentButton = new Button(composite, 32);
            deleteContentButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            deleteContentButton.setText(Messages.UnbindActionDeleteContentsLabel);
            deleteContentButton.setFocus();
            deleteContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    deleteContent = deleteContentButton.getSelection();
                }
            });
            Text locationLabel = new Text(composite, 8);
            GridData labelData = new GridData(4, 4, true, false);
            labelData.verticalIndent = 5;
            locationLabel.setLayoutData((Object)labelData);
            if (this.apps.size() == 1) {
                locationLabel.setText(Messages.UnbindActionLocationLabel);
            } else {
                locationLabel.setText(NLS.bind((String)Messages.UnbindActionMultipleLocationLabel, (Object)this.apps.size()));
            }
            locationLabel.setForeground(composite.getForeground());
            locationLabel.setBackground(composite.getBackground());
            int style = 586;
            if (this.apps.size() > 1) {
                style |= 0x800;
            }
            StyledText locationList = new StyledText(composite, style);
            locationList.setAlwaysShowScrollBars(false);
            labelData.horizontalIndent = locationList.getLeftMargin();
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = this.convertHeightInCharsToPixels(Math.min(this.apps.size(), 5));
            locationList.setLayoutData((Object)data);
            locationList.setForeground(composite.getForeground());
            locationList.setBackground(composite.getBackground());
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.apps.size(); ++i) {
                String location = this.apps.get((int)i).fullLocalPath.toOSString();
                if (location == null) continue;
                if (buffer.length() > 0) {
                    buffer.append('\n');
                }
                buffer.append(location);
            }
            locationList.setText(buffer.toString());
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }
    }
}

