/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;

public class NewCodewindProjectPage
extends WizardPage {
    private static final Pattern projectNamePattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
    private CodewindConnection connection;
    private List<ProjectTemplateInfo> templateList;
    private SearchPattern pattern = new SearchPattern(35);
    private Text filterText;
    private Table selectionTable;
    private Text descriptionLabel;
    private Text projectNameText;

    protected NewCodewindProjectPage(CodewindConnection connection, List<ProjectTemplateInfo> templateList) {
        super(Messages.NewProjectPage_ShellTitle);
        this.setTitle(Messages.NewProjectPage_WizardTitle);
        this.setDescription(Messages.NewProjectPage_WizardDescription);
        this.connection = connection;
        this.templateList = templateList;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        if (this.connection == null) {
            this.setupConnection();
            if (this.connection == null) {
                this.setErrorMessage(Messages.NewProjectPage_CodewindConnectError);
                this.setControl((Control)composite);
                return;
            }
        }
        if (this.templateList == null || this.templateList.isEmpty()) {
            this.getTemplates();
            if (this.templateList == null || this.templateList.isEmpty()) {
                this.setErrorMessage(Messages.NewProjectPage_TemplateListError);
                this.setControl((Control)composite);
                return;
            }
        }
        this.templateList.sort(new Comparator<ProjectTemplateInfo>(){

            @Override
            public int compare(ProjectTemplateInfo info1, ProjectTemplateInfo info2) {
                return info1.getLabel().compareTo(info2.getLabel());
            }
        });
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    private void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.NewProjectPage_ProjectNameLabel);
        this.projectNameText = new Text(composite, 2048);
        this.projectNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label spacer = new Label(composite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Text templateText = new Text(composite, 8);
        templateText.setText(Messages.NewProjectPage_TemplateGroupLabel);
        templateText.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        templateText.setBackground(composite.getBackground());
        templateText.setForeground(composite.getForeground());
        Group templateGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.filterText = new Text((Composite)templateGroup, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.filterText.setMessage(Messages.NewProjectPage_FilterMessage);
        this.selectionTable = new Table((Composite)templateGroup, 68352);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = 100;
        this.selectionTable.setLayoutData((Object)data);
        final TableColumn templateColumn = new TableColumn(this.selectionTable, 0);
        templateColumn.setText(Messages.NewProjectPage_TemplateColumn);
        templateColumn.setResizable(true);
        templateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, templateColumn);
            }
        });
        final TableColumn typeColumn = new TableColumn(this.selectionTable, 0);
        typeColumn.setText(Messages.NewProjectPage_TypeColumn);
        typeColumn.setResizable(true);
        typeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, typeColumn);
            }
        });
        final TableColumn languageColumn = new TableColumn(this.selectionTable, 0);
        languageColumn.setText(Messages.NewProjectPage_LanguageColumn);
        languageColumn.setResizable(true);
        languageColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, languageColumn);
            }
        });
        this.selectionTable.setHeaderVisible(true);
        this.selectionTable.setLinesVisible(false);
        this.selectionTable.setSortDirection(1024);
        this.selectionTable.setSortColumn(templateColumn);
        this.createItems(this.selectionTable, "");
        this.resizeColumns(this.selectionTable);
        ScrolledComposite descriptionScroll = new ScrolledComposite((Composite)templateGroup, 512);
        this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
        this.descriptionLabel.setText(NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)""));
        this.descriptionLabel.setBackground(templateGroup.getBackground());
        this.descriptionLabel.setForeground(templateGroup.getForeground());
        descriptionScroll.setContent((Control)this.descriptionLabel);
        data = new GridData(4, 4, true, false);
        int lineHeight = this.filterText.computeSize((int)-1, (int)-1).y;
        data.heightHint = lineHeight * 2;
        data.horizontalSpan = 2;
        descriptionScroll.setLayoutData((Object)data);
        descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll.getVerticalBar().setIncrement(lineHeight);
        descriptionScroll.setBackground(templateGroup.getBackground());
        descriptionScroll.setForeground(templateGroup.getForeground());
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = NewCodewindProjectPage.this.filterText.getText();
                if (text == null) {
                    text = "";
                }
                NewCodewindProjectPage.this.createItems(NewCodewindProjectPage.this.selectionTable, text);
                if (NewCodewindProjectPage.this.selectionTable.getItemCount() > 0) {
                    NewCodewindProjectPage.this.selectionTable.select(0);
                }
                NewCodewindProjectPage.this.updateDescription();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    if (NewCodewindProjectPage.this.selectionTable.getItemCount() > 0) {
                        NewCodewindProjectPage.this.selectionTable.setSelection(0);
                        NewCodewindProjectPage.this.updateDescription();
                        NewCodewindProjectPage.this.selectionTable.setFocus();
                    }
                    event.doit = false;
                    NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
                }
            }
        });
        this.selectionTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewCodewindProjectPage.this.updateDescription();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.setSelection(0);
        }
        this.updateDescription();
        this.descriptionLabel.setSize(this.descriptionLabel.computeSize(-1, -1));
        this.projectNameText.setFocus();
    }

    private boolean validate() {
        String projectName = this.projectNameText.getText();
        if (projectName == null || projectName.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyProjectName);
            return false;
        }
        if (!projectNamePattern.matcher(projectName).matches()) {
            this.setErrorMessage(Messages.NewProjectPage_InvalidProjectName);
            return false;
        }
        if (this.connection.getAppByName(projectName) != null) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_ProjectExistsError, (Object)projectName));
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.exists()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_EclipseProjectExistsError, (Object)projectName));
            return false;
        }
        this.setErrorMessage(null);
        return this.selectionTable.getSelectionCount() == 1 && projectName != null && !projectName.isEmpty();
    }

    public ProjectTemplateInfo getProjectTemplateInfo() {
        int index;
        if (this.selectionTable != null && (index = this.selectionTable.getSelectionIndex()) >= 0) {
            TableItem item = this.selectionTable.getItem(index);
            return (ProjectTemplateInfo)item.getData();
        }
        return null;
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public String getProjectName() {
        if (this.projectNameText != null) {
            return this.projectNameText.getText();
        }
        return null;
    }

    private void createItems(Table table, String filter) {
        table.removeAll();
        this.pattern.setPattern("*" + filter + "*");
        for (ProjectTemplateInfo templateInfo : this.templateList) {
            String template = templateInfo.getLabel();
            String type = ProjectType.getDisplayName((String)templateInfo.getProjectType());
            String language = ProjectLanguage.getDisplayName((String)templateInfo.getLanguage());
            if (!this.pattern.matches(template) && (type == null || !this.pattern.matches(type)) && (language == null || !this.pattern.matches(language))) continue;
            TableItem item = new TableItem(table, 0);
            item.setForeground(table.getForeground());
            item.setBackground(table.getBackground());
            item.setText(0, template);
            if (type != null) {
                item.setText(1, type);
            }
            if (language != null) {
                item.setText(2, language);
            }
            item.setData((Object)templateInfo);
        }
    }

    public static void sortTable(Table table, TableColumn column) {
        int i;
        TableItem[] items = table.getItems();
        int rows = items.length;
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        int[] map = new int[rows];
        for (i = 0; i < rows; ++i) {
            map[i] = i;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                TableItem a = items[map[i]];
                TableItem b = items[map[j]];
                if (a.getText(columnNum).toLowerCase().compareTo(b.getText(columnNum).toLowerCase()) * dir <= 0) continue;
                int t = map[i];
                map[i] = map[j];
                map[j] = t;
            }
        }
        for (i = 0; i < rows; ++i) {
            int n = map[i];
            TableItem item = new TableItem(table, 0);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                item.setText(j, items[n].getText(j));
            }
            item.setImage(items[n].getImage());
            item.setForeground(items[n].getForeground());
            item.setBackground(items[n].getBackground());
            item.setGrayed(items[n].getGrayed());
            item.setChecked(items[n].getChecked());
            item.setData(items[n].getData());
            items[n].dispose();
        }
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
    }

    public void updateDescription() {
        TableItem[] items = this.selectionTable.getSelection();
        String description = "";
        boolean enabled = false;
        if (items.length == 1) {
            enabled = true;
            description = ((ProjectTemplateInfo)items[0].getData()).getDescription();
            if (description == null || description.isEmpty()) {
                description = Messages.NewProjectPage_DescriptionNone;
            }
        }
        String text = NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)description);
        this.descriptionLabel.setText(text);
        int width = this.descriptionLabel.getParent().getClientArea().width;
        this.descriptionLabel.setSize(width, this.descriptionLabel.computeSize((int)width, (int)-1).y);
        int newWidth = this.descriptionLabel.getParent().getClientArea().width;
        if (newWidth != width) {
            this.descriptionLabel.setSize(newWidth, this.descriptionLabel.computeSize((int)newWidth, (int)-1).y);
        }
        this.descriptionLabel.setEnabled(enabled);
    }

    public void resizeColumns(Table table) {
        int i;
        TableLayout tableLayout = new TableLayout();
        int numColumns = table.getColumnCount();
        for (i = 0; i < numColumns; ++i) {
            table.getColumn(i).pack();
        }
        for (i = 0; i < numColumns; ++i) {
            int w = Math.max(75, table.getColumn(i).getWidth());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(w, w, true));
        }
        table.setLayout((Layout)tableLayout);
    }

    private void setupConnection() {
        final CodewindManager manager = CodewindManager.getManager();
        this.connection = manager.getLocalConnection();
        if (this.connection != null && this.connection.isConnected()) {
            return;
        }
        final InstallStatus status = manager.getInstallStatus(true);
        if (status.isStarted()) {
            this.connection = manager.createLocalConnection();
            return;
        }
        if (!status.isInstalled()) {
            Logger.logError((String)"In NewCodewindProjectPage setupConnection method and Codewind is not installed or has unknown status.");
            this.connection = null;
            return;
        }
        this.connection = null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                    if (result.getExitValue() != 0) {
                        Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                        throw new InvocationTargetException(null, "There was a problem while trying to start Codewind: " + errorText);
                    }
                    NewCodewindProjectPage.this.connection = manager.createLocalConnection();
                    ViewHelper.refreshCodewindExplorerView(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                }
                catch (TimeoutException e) {
                    throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                }
            }
        };
        try {
            this.getWizard().getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
            return;
        }
        if (this.connection == null) {
            Logger.logError((String)("Failed to connect to Codewind at: " + manager.getLocalURI()));
        }
    }

    private void getTemplates() {
        try {
            this.templateList = this.connection.requestProjectTemplates();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred trying to get the list of templates", (Throwable)e);
        }
    }
}

