/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RestartRunModeAction
extends SelectionProviderAction {
    public static final String ACTION_ID = "org.eclipse.codewind.ui.restartRunModeAction";
    protected CodewindEclipseApplication app;

    public RestartRunModeAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RestartInRunMode);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/launch_run.gif"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.getProjectCapabilities().canRestart()) {
                this.setEnabled(this.app.getAppStatus() == AppStatus.STARTED || this.app.getAppStatus() == AppStatus.STARTING);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"RestartRunModeAction ran but no application was selected");
            return;
        }
        try {
            this.app.clearDebugger();
            this.app.connection.requestProjectRestart((CodewindApplication)this.app, StartMode.RUN.startMode);
        }
        catch (Exception e) {
            Logger.logError((String)("Error initiating restart for project: " + this.app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)Messages.ErrorOnRestartDialogTitle, (String)e.getMessage());
            return;
        }
    }

    public boolean showAction() {
        return this.app != null && this.app.isAvailable() && this.app.getProjectCapabilities().canRestart();
    }
}

