/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.console;

import org.eclipse.codewind.core.internal.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectTemplateInfo {
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";
    public static final String URL_KEY = "url";
    public static final String LANGUAGE_KEY = "language";
    public static final String PROJECT_TYPE_KEY = "projectType";
    private JSONObject projectInfo;

    public ProjectTemplateInfo(JSONObject projectInfo) {
        this.projectInfo = projectInfo;
    }

    public String getLabel() {
        return this.getString(LABEL_KEY);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION_KEY);
    }

    public String getLanguage() {
        return this.getString(LANGUAGE_KEY);
    }

    public String getUrl() {
        return this.getString(URL_KEY);
    }

    public String getProjectType() {
        return this.getString(PROJECT_TYPE_KEY);
    }

    private String getString(String key) {
        String value = null;
        if (this.projectInfo.has(key)) {
            try {
                value = this.projectInfo.getString(key);
            }
            catch (JSONException e) {
                Logger.logError("An error occurred retrieving the value from the project template object for key: " + key, e);
            }
        } else {
            Logger.logError("The project template object did not have the expected key: " + key);
        }
        return value;
    }

    public String toString() {
        return this.projectInfo.toString();
    }
}

