/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.messages.Messages;

public enum BuildStatus {
    IN_PROGRESS("inProgress", Messages.BuildStateInProgress),
    SUCCESS("success", Messages.BuildStateSuccess),
    FAILED("failed", Messages.BuildStateFailed),
    QUEUED("queued", Messages.BuildStateQueued),
    UNKOWN("unknown", Messages.BuildStateUnknown);

    public static final String BUILD_REQUIRED = "buildRequired";
    public final String status;
    public final String displayString;

    private BuildStatus(String buildStatus, String displayString) {
        this.status = buildStatus;
        this.displayString = displayString;
    }

    public static BuildStatus get(String buildStatus) {
        if (BUILD_REQUIRED.equals(buildStatus)) {
            return null;
        }
        for (BuildStatus status : BuildStatus.values()) {
            if (!status.status.equals(buildStatus)) continue;
            return status;
        }
        Logger.logError("Unrecognized application state: " + buildStatus);
        return UNKOWN;
    }

    public boolean isComplete() {
        return this == SUCCESS || this == FAILED;
    }

    public String getDisplayString() {
        return this.displayString;
    }
}

