/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.json.JSONException;

public class CodewindManager {
    private static CodewindManager codewindManager;
    CodewindConnection localConnection = null;
    URI localURI = null;
    InstallStatus installStatus = null;
    InstallerStatus installerStatus = null;

    private CodewindManager() {
        if (this.getInstallStatus(true).isStarted()) {
            this.createLocalConnection();
            if (this.localConnection != null) {
                this.localConnection.refreshApps(null);
            }
        }
    }

    public static CodewindManager getManager() {
        if (codewindManager == null) {
            codewindManager = new CodewindManager();
        }
        return codewindManager;
    }

    public InstallStatus getInstallStatus(boolean update) {
        if (this.installStatus != null && !update) {
            return this.installStatus;
        }
        String url = null;
        try {
            this.installStatus = InstallUtil.getInstallStatus();
            if (this.installStatus.isStarted()) {
                this.localURI = new URI(this.installStatus.getURL());
            } else {
                this.removeLocalConnection();
                this.localURI = null;
            }
            return this.installStatus;
        }
        catch (IOException e) {
            Logger.logError("An error occurred trying to get the installer status", e);
        }
        catch (TimeoutException e) {
            Logger.logError("Timed out trying to get the installer status", e);
        }
        catch (JSONException e) {
            Logger.logError("The Codewind installer status format is not recognized", e);
        }
        catch (URISyntaxException e) {
            Logger.logError("The Codewind installer status command returned an invalid url: " + url, e);
        }
        return InstallStatus.UNKNOWN;
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateAll();
    }

    public URI getLocalURI() {
        if (this.localURI == null) {
            this.getInstallStatus(true);
        }
        return this.localURI;
    }

    public boolean isSupportedVersion(String version) {
        return CodewindConnection.isSupportedVersion(version);
    }

    public synchronized CodewindConnection getLocalConnection() {
        return this.localConnection;
    }

    public synchronized CodewindConnection createLocalConnection() {
        if (this.localConnection != null) {
            return this.localConnection;
        }
        try {
            CodewindConnection connection;
            this.localConnection = connection = CodewindObjectFactory.createCodewindConnection(this.getLocalURI());
            CodewindConnectionManager.add(connection);
            return connection;
        }
        catch (Exception e) {
            Logger.log("Attempting to connect to Codewind failed: " + e.getMessage());
            return null;
        }
    }

    public synchronized void removeLocalConnection() {
        if (this.localConnection != null) {
            this.localConnection.close();
            CodewindConnectionManager.removeConnection(this.localConnection.baseUrl.toString());
            this.localConnection = null;
        }
    }

    public void refresh() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            conn.refreshApps(null);
        }
    }

    public boolean hasActiveApplications() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            for (CodewindApplication app : conn.getApps()) {
                if (!app.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

