/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public class InstallUtil {
    public static final String STOP_APP_CONTAINERS_PREFSKEY = "stopAppContainers";
    public static final String STOP_APP_CONTAINERS_ALWAYS = "stopAppContainersAlways";
    public static final String STOP_APP_CONTAINERS_NEVER = "stopAppContainersNever";
    public static final String STOP_APP_CONTAINERS_PROMPT = "stopAppContainersPrompt";
    public static final String STOP_APP_CONTAINERS_DEFAULT = "stopAppContainersPrompt";
    private static final Map<PlatformUtil.OperatingSystem, String> installMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final String INSTALLER_DIR = "installerWorkDir";
    private static final String INSTALL_CMD = "install";
    private static final String START_CMD = "start";
    private static final String STOP_CMD = "stop";
    private static final String STOP_ALL_CMD = "stop-all";
    private static final String STATUS_CMD = "status";
    private static final String REMOVE_CMD = "remove";
    public static final String DEFAULT_INSTALL_VERSION = "0.3.1";
    private static final String TAG_OPTION = "-t";
    private static final String JSON_OPTION = "-j";
    private static final String INSTALL_VERSION_VAR = "INSTALL_VERSION";
    public static final String STATUS_KEY = "status";
    public static final String URL_KEY = "url";
    private static String installVersion;
    private static String installExec;

    public static InstallStatus getInstallStatus() throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = InstallUtil.statusCodewind();
        if (result.getExitValue() != 0) {
            String error = result.getError();
            if (error == null || error.isEmpty()) {
                error = result.getOutput();
            }
            String msg = "Installer status command failed with rc: " + result.getExitValue() + " and error: " + error;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        JSONObject status = new JSONObject(result.getOutput());
        return new InstallStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult startCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StartCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STARTING);
            process = InstallUtil.runInstaller(START_CMD, TAG_OPTION, version);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(90));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult stopCodewind(boolean stopAll, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StopCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STOPPING);
            process = InstallUtil.runInstaller(stopAll ? STOP_ALL_CMD : STOP_CMD, new String[0]);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult installCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.INSTALLING);
            process = InstallUtil.runInstaller(INSTALL_CMD, TAG_OPTION, version);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 1000, 300, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult removeCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RemovingCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.UNINSTALLING);
            process = version != null ? InstallUtil.runInstaller(REMOVE_CMD, TAG_OPTION, version) : InstallUtil.runInstaller(REMOVE_CMD, new String[0]);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    private static ProcessHelper.ProcessResult statusCodewind() throws IOException, TimeoutException {
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            process = InstallUtil.runInstaller("status", JSON_OPTION);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)new NullProgressMonitor());
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static Process runInstaller(String cmd, String ... options) throws IOException {
        String installerPath = InstallUtil.getInstallerExecutable();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(installerPath);
        cmdList.add(cmd);
        if (options != null) {
            for (String option : options) {
                cmdList.add(option);
            }
        }
        String[] command = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin:" + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        return builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstallerExecutable() throws IOException {
        if (installExec != null && new File(installExec).exists()) {
            return installExec;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        String relPath = installMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable";
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String installerDir = InstallUtil.getInstallerDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)CodewindCorePlugin.getDefault().getBundle(), (IPath)new Path(relPath), (boolean)false);
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = installExec = execPath;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getInstallerDir() {
        IPath stateLoc = CodewindCorePlugin.getDefault().getStateLocation();
        return stateLoc.append(INSTALLER_DIR).toOSString();
    }

    public static String getVersion() {
        if (installVersion == null) {
            String value = System.getenv(INSTALL_VERSION_VAR);
            installVersion = value != null && !value.isEmpty() ? value : DEFAULT_INSTALL_VERSION;
        }
        return installVersion;
    }

    static {
        installMap.put(PlatformUtil.OperatingSystem.LINUX, "resources/codewind-installer-linux");
        installMap.put(PlatformUtil.OperatingSystem.MAC, "resources/codewind-installer-macos");
        installMap.put(PlatformUtil.OperatingSystem.WINDOWS, "resources/codewind-installer-win.exe");
        installVersion = null;
        installExec = null;
    }
}

