/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.InstallerAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class CodewindActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private InstallerAction installUninstallAction;
    private InstallerAction startStopAction;
    private CodewindDoubleClickAction doubleClickAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.installUninstallAction = new InstallerAction(InstallerAction.ActionType.INSTALL_UNINSTALL, this.selProvider);
        this.startStopAction = new InstallerAction(InstallerAction.ActionType.START_STOP, this.selProvider);
        this.doubleClickAction = new CodewindDoubleClickAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (CodewindManager.getManager().getInstallerStatus() != null) {
            return;
        }
        this.selProvider.setSelection(this.selProvider.getSelection());
        InstallStatus status = CodewindManager.getManager().getInstallStatus(false);
        menu.appendToGroup("group.open", (IAction)this.installUninstallAction);
        if (status.isStarted()) {
            menu.appendToGroup("group.open", (IAction)this.startStopAction);
        } else if (status.isInstalled()) {
            menu.appendToGroup("group.open", (IAction)this.startStopAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    private static class CodewindDoubleClickAction
    extends SelectionProviderAction {
        CodewindManager manager = null;

        public CodewindDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            Object obj;
            if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindManager) {
                this.manager = (CodewindManager)obj;
                return;
            }
            this.manager = null;
        }

        public void run() {
            if (this.manager != null) {
                InstallStatus status = this.manager.getInstallStatus(false);
                if (status.isStarted()) {
                    ViewHelper.toggleExpansion(this.manager);
                } else if (status.isInstalled()) {
                    CodewindInstall.startCodewind(status.getVersion(), null);
                } else if (status.hasInstalledVersions()) {
                    boolean result = IDEUtil.openConfirmDialog(Messages.UpdateCodewindDialogTitle, Messages.UpdateCodewindDialogMsg);
                    if (result) {
                        CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, null);
                    }
                } else if (!status.isUnknown()) {
                    CodewindInstall.installCodewind(InstallUtil.getVersion(), null);
                }
            }
        }
    }
}

